/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log;

import java.nio.ByteBuffer;
import org.apache.iotdb.cluster.exception.UnknownLogTypeException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.CloseFileLog;
import org.apache.iotdb.cluster.log.logtypes.EmptyContentLog;
import org.apache.iotdb.cluster.log.logtypes.LargeTestLog;
import org.apache.iotdb.cluster.log.logtypes.PhysicalPlanLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogParser {
    private static final Logger logger = LoggerFactory.getLogger(LogParser.class);
    private static final LogParser INSTANCE = new LogParser();

    private LogParser() {
    }

    public static LogParser getINSTANCE() {
        return INSTANCE;
    }

    public Log parse(ByteBuffer buffer) throws UnknownLogTypeException {
        Log log;
        Log.Types type;
        if (logger.isDebugEnabled()) {
            logger.debug("Received a log buffer, pos:{}, limit:{}", (Object)buffer.position(), (Object)buffer.limit());
        }
        byte typeInt = buffer.get();
        try {
            type = Log.Types.values()[typeInt];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnknownLogTypeException(typeInt);
        }
        logger.debug("The log type is {}", (Object)type);
        switch (type) {
            case ADD_NODE: {
                AddNodeLog addNodeLog = new AddNodeLog();
                addNodeLog.deserialize(buffer);
                if (logger.isDebugEnabled()) {
                    logger.debug("The last meta log index of log {} is {}", (Object)addNodeLog, (Object)addNodeLog.getMetaLogIndex());
                }
                log = addNodeLog;
                break;
            }
            case PHYSICAL_PLAN: {
                PhysicalPlanLog physicalPlanLog = new PhysicalPlanLog();
                physicalPlanLog.deserialize(buffer);
                log = physicalPlanLog;
                break;
            }
            case CLOSE_FILE: {
                CloseFileLog closeFileLog = new CloseFileLog();
                closeFileLog.deserialize(buffer);
                log = closeFileLog;
                break;
            }
            case REMOVE_NODE: {
                RemoveNodeLog removeNodeLog = new RemoveNodeLog();
                removeNodeLog.deserialize(buffer);
                if (logger.isDebugEnabled()) {
                    logger.debug("The last meta log index of log {} is {}", (Object)removeNodeLog, (Object)removeNodeLog.getMetaLogIndex());
                }
                log = removeNodeLog;
                break;
            }
            case EMPTY_CONTENT: {
                EmptyContentLog emptyLog = new EmptyContentLog();
                emptyLog.deserialize(buffer);
                log = emptyLog;
                break;
            }
            case TEST_LARGE_CONTENT: {
                LargeTestLog largeLog = new LargeTestLog();
                largeLog.deserialize(buffer);
                log = largeLog;
                break;
            }
            default: {
                throw new IllegalArgumentException(type.toString());
            }
        }
        logger.debug("Parsed a log {}", (Object)log);
        return log;
    }
}

