/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Phaser;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.SettleCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICrossSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.SettleSelectorImpl;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final ReadWriteLock compactionTaskSelectionLock = new ReentrantReadWriteLock();

    private CompactionScheduler() {
    }

    public static void sharedLockCompactionSelection() {
        compactionTaskSelectionLock.readLock().lock();
    }

    public static void sharedUnlockCompactionSelection() {
        compactionTaskSelectionLock.readLock().unlock();
    }

    public static void exclusiveLockCompactionSelection() {
        compactionTaskSelectionLock.writeLock().lock();
    }

    public static void exclusiveUnlockCompactionSelection() {
        compactionTaskSelectionLock.writeLock().unlock();
    }

    public static void scheduleCompaction(TsFileManager tsFileManager, long timePartition, CompactionScheduleContext context) throws InterruptedException {
        if (!tsFileManager.isAllowCompaction()) {
            return;
        }
        try {
            boolean executeDelayedInsertionSelection;
            int submitInnerTaskNum = 0;
            submitInnerTaskNum += CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, true, context);
            boolean bl = executeDelayedInsertionSelection = (submitInnerTaskNum += CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, false, context)) == 0 && context.isInsertionSelectionDelayed(timePartition);
            if (executeDelayedInsertionSelection) {
                CompactionScheduler.scheduleInsertionCompaction(tsFileManager, timePartition, context);
            }
            CompactionScheduler.tryToSubmitCrossSpaceCompactionTask(tsFileManager, timePartition, context);
            CompactionScheduler.tryToSubmitSettleCompactionTask(tsFileManager, timePartition, context, false);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("Meet error in compaction schedule.", e);
        }
    }

    public static void scheduleCompaction(TsFileManager tsFileManager, long timePartition) throws InterruptedException {
        CompactionScheduler.scheduleCompaction(tsFileManager, timePartition, new CompactionScheduleContext());
    }

    public static int tryToSubmitInnerSpaceCompactionTask(TsFileManager tsFileManager, long timePartition, boolean sequence, CompactionScheduleContext context) throws InterruptedException {
        if (!config.isEnableSeqSpaceCompaction() && sequence || !config.isEnableUnseqSpaceCompaction() && !sequence) {
            return 0;
        }
        String storageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        long compactionConfigVersionWhenSelectTask = CompactionTaskManager.getInstance().getCurrentCompactionConfigVersion();
        ICompactionSelector innerSpaceCompactionSelector = sequence ? config.getInnerSequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager, context) : config.getInnerUnsequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager, context);
        long startTime = System.currentTimeMillis();
        List<InnerSpaceCompactionTask> innerSpaceTaskList = innerSpaceCompactionSelector.selectInnerSpaceTask(tsFileManager.getTsFileListSnapshot(timePartition, sequence));
        CompactionMetrics.getInstance().updateCompactionTaskSelectionTimeCost(sequence ? CompactionTaskType.INNER_SEQ : CompactionTaskType.INNER_UNSEQ, System.currentTimeMillis() - startTime);
        innerSpaceTaskList.forEach(task -> task.setCompactionConfigVersion(compactionConfigVersionWhenSelectTask));
        int trySubmitCount = CompactionScheduler.addTaskToWaitingQueue(innerSpaceTaskList);
        context.incrementSubmitTaskNum(sequence ? CompactionTaskType.INNER_SEQ : CompactionTaskType.INNER_UNSEQ, trySubmitCount);
        return trySubmitCount;
    }

    private static int addTaskToWaitingQueue(List<? extends AbstractCompactionTask> tasks) throws InterruptedException {
        int trySubmitCount = 0;
        for (AbstractCompactionTask abstractCompactionTask : tasks) {
            if (!CompactionScheduler.canAddTaskToWaitingQueue(abstractCompactionTask) || !CompactionTaskManager.getInstance().addTaskToWaitingQueue(abstractCompactionTask)) continue;
            ++trySubmitCount;
        }
        return trySubmitCount;
    }

    private static boolean canAddTaskToWaitingQueue(AbstractCompactionTask task) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long fileNumLimitForCompaction = SystemInfo.getInstance().getTotalFileLimitForCompaction();
        if ((long)task.getProcessedFileNum() > fileNumLimitForCompaction) {
            return false;
        }
        if (!task.isDiskSpaceCheckPassed()) {
            LOGGER.info("Compaction task start check failed because disk free ratio is less than disk_space_warning_threshold");
            return false;
        }
        return true;
    }

    public static int scheduleInsertionCompaction(TsFileManager tsFileManager, long timePartition, CompactionScheduleContext context) throws InterruptedException {
        int count = 0;
        while (true) {
            Phaser insertionTaskPhaser = new Phaser(1);
            int selectedTaskNum = CompactionScheduler.tryToSubmitInsertionCompactionTask(tsFileManager, timePartition, insertionTaskPhaser, context);
            insertionTaskPhaser.awaitAdvanceInterruptibly(insertionTaskPhaser.arrive());
            if (selectedTaskNum <= 0) break;
            count += selectedTaskNum;
        }
        return count;
    }

    public static int tryToSubmitInsertionCompactionTask(TsFileManager tsFileManager, long timePartition, Phaser insertionTaskPhaser, CompactionScheduleContext context) throws InterruptedException {
        String dataRegionId;
        if (!tsFileManager.isAllowCompaction() || !config.isEnableCrossSpaceCompaction()) {
            return 0;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(logicalStorageGroupName, dataRegionId = tsFileManager.getDataRegionId(), timePartition, tsFileManager, context);
        List<CrossCompactionTaskResource> selectedTasks = selector.selectInsertionCrossSpaceTask(tsFileManager.getTsFileListSnapshot(timePartition, true), tsFileManager.getTsFileListSnapshot(timePartition, false));
        if (selectedTasks.isEmpty()) {
            return 0;
        }
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(insertionTaskPhaser, timePartition, tsFileManager, (InsertionCrossCompactionTaskResource)selectedTasks.get(0), tsFileManager.getNextCompactionTaskId());
        insertionTaskPhaser.register();
        if (!CompactionTaskManager.getInstance().addTaskToWaitingQueue(task)) {
            insertionTaskPhaser.arrive();
            return 0;
        }
        return 1;
    }

    private static int tryToSubmitCrossSpaceCompactionTask(TsFileManager tsFileManager, long timePartition, CompactionScheduleContext context) throws InterruptedException {
        if (!config.isEnableCrossSpaceCompaction()) {
            return 0;
        }
        if (!CompactionTaskManager.getInstance().shouldSelectCrossSpaceCompactionTask()) {
            return 0;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        long compactionConfigVersionWhenSelectTask = CompactionTaskManager.getInstance().getCurrentCompactionConfigVersion();
        ICrossSpaceSelector crossSpaceCompactionSelector = config.getCrossCompactionSelector().createInstance(logicalStorageGroupName, dataRegionId, timePartition, tsFileManager, context);
        List<CrossCompactionTaskResource> taskList = crossSpaceCompactionSelector.selectCrossSpaceTask(tsFileManager.getTsFileListSnapshot(timePartition, true), tsFileManager.getTsFileListSnapshot(timePartition, false));
        List memoryCost = taskList.stream().map(CrossCompactionTaskResource::getTotalMemoryCost).collect(Collectors.toList());
        int trySubmitCount = 0;
        int size = taskList.size();
        for (int i = 0; i < size; ++i) {
            CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(timePartition, tsFileManager, taskList.get(i).getSeqFiles(), taskList.get(i).getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), (Long)memoryCost.get(i), tsFileManager.getNextCompactionTaskId());
            task.setCompactionConfigVersion(compactionConfigVersionWhenSelectTask);
            trySubmitCount = CompactionScheduler.addTaskToWaitingQueue(Collections.singletonList(task));
        }
        context.incrementSubmitTaskNum(CompactionTaskType.CROSS, trySubmitCount);
        return trySubmitCount;
    }

    public static int tryToSubmitSettleCompactionTask(TsFileManager tsFileManager, long timePartition, CompactionScheduleContext context, boolean heavySelect) throws InterruptedException {
        if (!config.isEnableSeqSpaceCompaction() && !config.isEnableUnseqSpaceCompaction()) {
            return 0;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        SettleSelectorImpl settleSelector = new SettleSelectorImpl(heavySelect, logicalStorageGroupName, dataRegionId, timePartition, tsFileManager);
        long startTime = System.currentTimeMillis();
        ArrayList<SettleCompactionTask> taskList = new ArrayList<SettleCompactionTask>();
        if (config.isEnableSeqSpaceCompaction()) {
            taskList.addAll(settleSelector.selectSettleTask(tsFileManager.getTsFileListSnapshot(timePartition, true)));
        }
        if (config.isEnableUnseqSpaceCompaction()) {
            taskList.addAll(settleSelector.selectSettleTask(tsFileManager.getTsFileListSnapshot(timePartition, false)));
        }
        CompactionMetrics.getInstance().updateCompactionTaskSelectionTimeCost(CompactionTaskType.SETTLE, System.currentTimeMillis() - startTime);
        int trySubmitCount = 0;
        for (AbstractCompactionTask abstractCompactionTask : taskList) {
            if (!CompactionTaskManager.getInstance().addTaskToWaitingQueue(abstractCompactionTask)) continue;
            context.updateTTLInfo(abstractCompactionTask);
            ++trySubmitCount;
        }
        context.incrementSubmitTaskNum(CompactionTaskType.SETTLE, trySubmitCount);
        return trySubmitCount;
    }
}

