/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.scheduler.load;

import com.google.common.util.concurrent.Futures;
import io.airlift.concurrent.SetThreadName;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.queryengine.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.queryengine.plan.scheduler.IFragInstanceDispatcher;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileScheduler;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.mpp.rpc.thrift.TLoadCommandReq;
import org.apache.iotdb.mpp.rpc.thrift.TLoadResp;
import org.apache.iotdb.mpp.rpc.thrift.TTsFilePieceReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileDispatcherImpl
implements IFragInstanceDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileDispatcherImpl.class);
    private static final int MAX_CONNECTION_TIMEOUT_MS = 86400000;
    private static final int FIRST_ADJUSTMENT_TIMEOUT_MS = 21600000;
    private static final AtomicInteger CONNECTION_TIMEOUT_MS = new AtomicInteger(IoTDBDescriptor.getInstance().getConfig().getConnectionTimeoutInMS());
    private String uuid;
    private final String localhostIpAddr;
    private final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;
    private final ExecutorService executor;
    private final boolean isGeneratedByPipe;

    public LoadTsFileDispatcherImpl(IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager, boolean isGeneratedByPipe) {
        this.internalServiceClientManager = internalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
        this.executor = IoTDBThreadPoolFactory.newCachedThreadPool((String)LoadTsFileDispatcherImpl.class.getName());
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public Future<FragInstanceDispatchResult> dispatch(List<FragmentInstance> instances) {
        return this.executor.submit(() -> {
            for (FragmentInstance instance : instances) {
                try (SetThreadName threadName = new SetThreadName("load-dispatcher-" + instance.getId().getFullId() + "-" + this.uuid, new Object[0]);){
                    this.dispatchOneInstance(instance);
                }
                catch (FragmentInstanceDispatchException e) {
                    return new FragInstanceDispatchResult(e.getFailureStatus());
                }
                catch (Exception t) {
                    LOGGER.warn("cannot dispatch FI for load operation", (Throwable)t);
                    return new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage())));
                }
            }
            return new FragInstanceDispatchResult(true);
        });
    }

    private void dispatchOneInstance(FragmentInstance instance) throws FragmentInstanceDispatchException {
        TTsFilePieceReq loadTsFileReq = null;
        for (TDataNodeLocation dataNodeLocation : instance.getRegionReplicaSet().getDataNodeLocations()) {
            TEndPoint endPoint = dataNodeLocation.getInternalEndPoint();
            if (this.isDispatchedToLocal(endPoint)) {
                this.dispatchLocally(instance);
                continue;
            }
            if (loadTsFileReq == null) {
                loadTsFileReq = new TTsFilePieceReq(instance.getFragment().getPlanNodeTree().serializeToByteBuffer(), this.uuid, instance.getRegionReplicaSet().getRegionId());
            }
            this.dispatchRemote(loadTsFileReq, endPoint);
        }
    }

    public void dispatchLocally(FragmentInstance instance) throws FragmentInstanceDispatchException {
        LOGGER.info("Receive load node from uuid {}.", (Object)this.uuid);
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)instance.getRegionReplicaSet().getRegionId());
        PlanNode planNode = instance.getFragment().getPlanNodeTree();
        if (planNode instanceof LoadTsFilePieceNode) {
            LoadTsFilePieceNode pieceNode = (LoadTsFilePieceNode)PlanNodeType.deserialize(planNode.serializeToByteBuffer());
            if (pieceNode == null) {
                throw new FragmentInstanceDispatchException(new TSStatus(TSStatusCode.DESERIALIZE_PIECE_OF_TSFILE_ERROR.getStatusCode()));
            }
            TSStatus resultStatus = StorageEngine.getInstance().writeLoadTsFileNode((DataRegionId)groupId, pieceNode, this.uuid);
            if (!RpcUtils.SUCCESS_STATUS.equals(resultStatus)) {
                throw new FragmentInstanceDispatchException(resultStatus);
            }
        } else if (planNode instanceof LoadSingleTsFileNode) {
            TsFileResource tsFileResource = ((LoadSingleTsFileNode)planNode).getTsFileResource();
            try {
                PipeDataNodeAgent.runtime().assignProgressIndexForTsFileLoad(tsFileResource);
                tsFileResource.setGeneratedByPipe(this.isGeneratedByPipe);
                tsFileResource.serialize();
                StorageEngine.getInstance().getDataRegion((DataRegionId)groupId).loadNewTsFile(tsFileResource, ((LoadSingleTsFileNode)planNode).isDeleteAfterLoad(), this.isGeneratedByPipe, false);
            }
            catch (LoadFileException e) {
                LOGGER.warn("Load TsFile Node {} error.", (Object)planNode, (Object)e);
                TSStatus resultStatus = new TSStatus();
                resultStatus.setCode(TSStatusCode.LOAD_FILE_ERROR.getStatusCode());
                resultStatus.setMessage(e.getMessage());
                throw new FragmentInstanceDispatchException(resultStatus);
            }
            catch (IOException e) {
                LOGGER.warn("Serialize TsFileResource {} error.", (Object)tsFileResource.getTsFile().getAbsolutePath(), (Object)e);
                TSStatus resultStatus = new TSStatus();
                resultStatus.setCode(TSStatusCode.LOAD_FILE_ERROR.getStatusCode());
                resultStatus.setMessage(e.getMessage());
                throw new FragmentInstanceDispatchException(resultStatus);
            }
        }
    }

    private void dispatchRemote(TTsFilePieceReq loadTsFileReq, TEndPoint endPoint) throws FragmentInstanceDispatchException {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            client.setTimeout(CONNECTION_TIMEOUT_MS.get());
            TLoadResp loadResp = client.sendTsFilePieceNode(loadTsFileReq);
            if (!loadResp.isAccepted()) {
                LOGGER.warn(loadResp.message);
                throw new FragmentInstanceDispatchException(loadResp.status);
            }
        }
        catch (Exception e) {
            LoadTsFileDispatcherImpl.adjustTimeoutIfNecessary(e);
            String exceptionMessage = String.format("failed to dispatch load command %s to node %s because of exception: %s", loadTsFileReq, endPoint, e);
            LOGGER.warn(exceptionMessage, (Throwable)e);
            throw new FragmentInstanceDispatchException(new TSStatus().setCode(TSStatusCode.DISPATCH_ERROR.getStatusCode()).setMessage(exceptionMessage));
        }
    }

    public Future<FragInstanceDispatchResult> dispatchCommand(TLoadCommandReq originalLoadCommandReq, Set<TRegionReplicaSet> replicaSets) {
        HashSet<TEndPoint> allEndPoint = new HashSet<TEndPoint>();
        for (TRegionReplicaSet replicaSet : replicaSets) {
            for (TDataNodeLocation dataNodeLocation : replicaSet.getDataNodeLocations()) {
                allEndPoint.add(dataNodeLocation.getInternalEndPoint());
            }
        }
        for (TEndPoint endPoint : allEndPoint) {
            TLoadCommandReq duplicatedLoadCommandReq = originalLoadCommandReq.deepCopy();
            try (SetThreadName threadName = new SetThreadName("load-dispatcher-" + (Object)((Object)LoadTsFileScheduler.LoadCommand.values()[duplicatedLoadCommandReq.commandType]) + "-" + duplicatedLoadCommandReq.uuid, new Object[0]);){
                if (this.isDispatchedToLocal(endPoint)) {
                    this.dispatchLocally(duplicatedLoadCommandReq);
                    continue;
                }
                this.dispatchRemote(duplicatedLoadCommandReq, endPoint);
            }
            catch (FragmentInstanceDispatchException e) {
                LOGGER.warn("Cannot dispatch LoadCommand for load operation {}", (Object)duplicatedLoadCommandReq, (Object)e);
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(e.getFailureStatus()));
            }
            catch (Exception t) {
                LOGGER.warn("Cannot dispatch LoadCommand for load operation {}", (Object)duplicatedLoadCommandReq, (Object)t);
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage()))));
            }
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
    }

    private void dispatchLocally(TLoadCommandReq loadCommandReq) throws FragmentInstanceDispatchException {
        HashMap<TTimePartitionSlot, ProgressIndex> timePartitionProgressIndexMap = new HashMap<TTimePartitionSlot, ProgressIndex>();
        if (loadCommandReq.isSetTimePartition2ProgressIndex()) {
            for (Map.Entry entry : loadCommandReq.getTimePartition2ProgressIndex().entrySet()) {
                timePartitionProgressIndexMap.put((TTimePartitionSlot)entry.getKey(), ProgressIndexType.deserializeFrom((ByteBuffer)((ByteBuffer)entry.getValue())));
            }
        } else {
            TSStatus status = new TSStatus();
            status.setCode(TSStatusCode.LOAD_FILE_ERROR.getStatusCode());
            status.setMessage("Load command requires time partition to progress index map");
            throw new FragmentInstanceDispatchException(status);
        }
        TSStatus resultStatus = StorageEngine.getInstance().executeLoadCommand(LoadTsFileScheduler.LoadCommand.values()[loadCommandReq.commandType], loadCommandReq.uuid, loadCommandReq.isSetIsGeneratedByPipe() && loadCommandReq.isGeneratedByPipe, timePartitionProgressIndexMap);
        if (!RpcUtils.SUCCESS_STATUS.equals(resultStatus)) {
            throw new FragmentInstanceDispatchException(resultStatus);
        }
    }

    private void dispatchRemote(TLoadCommandReq loadCommandReq, TEndPoint endPoint) throws FragmentInstanceDispatchException {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            client.setTimeout(CONNECTION_TIMEOUT_MS.get());
            TLoadResp loadResp = client.sendLoadCommand(loadCommandReq);
            if (!loadResp.isAccepted()) {
                LOGGER.warn(loadResp.message);
                throw new FragmentInstanceDispatchException(loadResp.status);
            }
        }
        catch (Exception e) {
            LoadTsFileDispatcherImpl.adjustTimeoutIfNecessary(e);
            String exceptionMessage = String.format("failed to dispatch load command %s to node %s because of exception: %s", loadCommandReq, endPoint, e);
            LOGGER.warn(exceptionMessage, (Throwable)e);
            throw new FragmentInstanceDispatchException(new TSStatus().setCode(TSStatusCode.DISPATCH_ERROR.getStatusCode()).setMessage(exceptionMessage));
        }
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    private static void adjustTimeoutIfNecessary(Throwable e) {
        do {
            int newConnectionTimeout;
            if (!(e instanceof SocketTimeoutException) && !(e instanceof TimeoutException)) continue;
            try {
                newConnectionTimeout = Math.min(Math.max(21600000, Math.toIntExact((long)CONNECTION_TIMEOUT_MS.get() * 2L)), 86400000);
            }
            catch (ArithmeticException arithmeticException) {
                newConnectionTimeout = 86400000;
            }
            if (newConnectionTimeout != CONNECTION_TIMEOUT_MS.get()) {
                CONNECTION_TIMEOUT_MS.set(newConnectionTimeout);
                LOGGER.info("Load remote procedure call connection timeout is adjusted to {} ms ({} mins)", (Object)newConnectionTimeout, (Object)((double)newConnectionTimeout / 60000.0));
            }
            return;
        } while ((e = e.getCause()) != null);
    }

    @Override
    public void abort() {
    }
}

