/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import sun.misc.Cleaner;

public class DoubleLargeArray
extends LargeArray {
    private static final long serialVersionUID = 7436383149749497101L;
    private double[] data;

    public DoubleLargeArray(long length) {
        this(length, true);
    }

    public DoubleLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.DOUBLE;
        this.sizeof = 8L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        if (length > (long)DoubleLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(length);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new double[(int)length];
        }
    }

    public DoubleLargeArray(long length, double constantValue) {
        this.type = LargeArrayType.DOUBLE;
        this.sizeof = 8L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new double[]{constantValue};
    }

    public DoubleLargeArray(double[] data) {
        this.type = LargeArrayType.DOUBLE;
        this.sizeof = 8L;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public DoubleLargeArray clone() {
        if (this.isConstant) {
            return new DoubleLargeArray(this.length, this.getDouble(0L));
        }
        DoubleLargeArray v = new DoubleLargeArray(this.length, false);
        LargeArrayUtils.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            DoubleLargeArray la = (DoubleLargeArray)o;
            return this.data == la.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
    }

    @Override
    public final Double get(long i) {
        return this.getDouble(i);
    }

    @Override
    public final Double getFromNative(long i) {
        return LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
    }

    @Override
    public final boolean getBoolean(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i) != 0.0;
        }
        if (this.isConstant) {
            return this.data[0] != 0.0;
        }
        return this.data[(int)i] != 0.0;
    }

    @Override
    public final byte getByte(long i) {
        if (this.ptr != 0L) {
            return (byte)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
        }
        if (this.isConstant) {
            return (byte)this.data[0];
        }
        return (byte)this.data[(int)i];
    }

    @Override
    public final short getUnsignedByte(long i) {
        if (this.ptr != 0L) {
            return (short)(0xFF & (int)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i));
        }
        if (this.isConstant) {
            return (short)(0xFF & (int)this.data[0]);
        }
        return (short)(0xFF & (int)this.data[(int)i]);
    }

    @Override
    public final short getShort(long i) {
        if (this.ptr != 0L) {
            return (short)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
        }
        if (this.isConstant) {
            return (short)this.data[0];
        }
        return (short)this.data[(int)i];
    }

    @Override
    public final int getInt(long i) {
        if (this.ptr != 0L) {
            return (int)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
        }
        if (this.isConstant) {
            return (int)this.data[0];
        }
        return (int)this.data[(int)i];
    }

    @Override
    public final long getLong(long i) {
        if (this.ptr != 0L) {
            return (long)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
        }
        if (this.isConstant) {
            return (long)this.data[0];
        }
        return (long)this.data[(int)i];
    }

    @Override
    public final float getFloat(long i) {
        if (this.ptr != 0L) {
            return (float)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
        }
        if (this.isConstant) {
            return (float)this.data[0];
        }
        return (float)this.data[(int)i];
    }

    @Override
    public final double getDouble(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    public final double[] getData() {
        return this.data;
    }

    @Override
    public final boolean[] getBooleanData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        boolean[] out = new boolean[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                double v = LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * (long)i);
                out[i] = v != 0.0;
                ++i;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0.0;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i] != 0.0;
                ++i;
            }
        }
        return out;
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        boolean[] out = a != null && (long)a.length >= len ? a : new boolean[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                double v = LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
                out[idx++] = v != 0.0;
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0] != 0.0;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                double v = this.data[(int)i];
                out[idx++] = v != 0.0;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        byte[] out = new byte[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (byte)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (byte)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (byte)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        byte[] out = a != null && (long)a.length >= len ? a : new byte[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        int[] out = new int[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (int)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (int)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (int)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData(int[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        int[] out = a != null && (long)a.length >= len ? a : new int[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        long[] out = new long[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (long)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (long)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (long)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData(long[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        long[] out = a != null && (long)a.length >= len ? a : new long[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (float)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (float)elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (float)this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (float)LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (float)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (float)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            System.arraycopy(this.data, 0, out, 0, (int)this.length);
        }
        return out;
    }

    @Override
    public final double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        double[] out = a != null && (long)a.length >= len ? a : new double[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getDouble(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final void setToNative(long i, Object value) {
        LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, (Double)value);
    }

    @Override
    public final void setBoolean(long i, boolean value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, value ? 1.0 : 0.0);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value ? 1.0 : 0.0;
        }
    }

    @Override
    public final void setByte(long i, byte value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setUnsignedByte(long i, short value) {
        this.setShort(i, value);
    }

    @Override
    public void setShort(long i, short value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setInt(long i, int value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setLong(long i, long value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setFloat(long i, float value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setDouble(long i, double value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putDouble(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }
}

