/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.memory;

import java.util.Arrays;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.memory.GlobalMemoryMetrics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryEngineMemoryMetrics
implements IMetricSet {
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final String QUERY_ENGINE = "QueryEngine";
    private static final String QUERY_ENGINE_BLOOM_FILTER_CACHE = "QueryEngine-BloomFilterCache";
    private static final String QUERY_ENGINE_CHUNK_CACHE = "QueryEngine-ChunkCache";
    private static final String QUERY_ENGINE_TIME_SERIES_METADATA_CACHE = "QueryEngine-TimeSeriesMetadataCache";
    private static final String QUERY_ENGINE_OPERATORS = "QueryEngine-Operators";
    private static final String QUERY_ENGINE_DATA_EXCHANGE = "QueryEngine-DataExchange";
    private static final String QUERY_ENGINE_TIME_INDEX = "QueryEngine-TimeIndex";
    private static final String QUERY_ENGINE_COORDINATOR = "QueryEngine-Coordinator";

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getQueryEngineMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getBloomFilterCacheMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_BLOOM_FILTER_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getBloomFilterCacheMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_BLOOM_FILTER_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getChunkCacheMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_CHUNK_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getChunkCacheMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_CHUNK_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getTimeSeriesMetaDataCacheMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_TIME_SERIES_METADATA_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getTimeSeriesMetaDataCacheMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_TIME_SERIES_METADATA_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getOperatorsMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_OPERATORS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getOperatorsMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_OPERATORS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getDataExchangeMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_DATA_EXCHANGE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getDataExchangeMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_DATA_EXCHANGE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getTimeIndexMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_TIME_INDEX, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getTimeIndexMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_TIME_INDEX, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getCoordinatorMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), QUERY_ENGINE_COORDINATOR, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), QUERY_ENGINE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        Arrays.asList(QUERY_ENGINE_BLOOM_FILTER_CACHE, QUERY_ENGINE_CHUNK_CACHE, QUERY_ENGINE_TIME_SERIES_METADATA_CACHE, QUERY_ENGINE_OPERATORS, QUERY_ENGINE_DATA_EXCHANGE, QUERY_ENGINE_TIME_INDEX, QUERY_ENGINE_COORDINATOR).forEach(name -> {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_ACTUAL_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        });
    }

    public static QueryEngineMemoryMetrics getInstance() {
        return QueryEngineMemoryMetricsHolder.INSTANCE;
    }

    private static class QueryEngineMemoryMetricsHolder {
        private static final QueryEngineMemoryMetrics INSTANCE = new QueryEngineMemoryMetrics();

        private QueryEngineMemoryMetricsHolder() {
        }
    }
}

