/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.unsafequeues;

import io.moquette.broker.unsafequeues.QueueException;
import io.moquette.broker.unsafequeues.QueuePool;
import io.moquette.broker.unsafequeues.Segment;
import io.moquette.broker.unsafequeues.SegmentAllocator;
import io.moquette.broker.unsafequeues.SegmentPointer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PagedFilesAllocator
implements SegmentAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(PagedFilesAllocator.class);
    private final Path pagesFolder;
    private final int pageSize;
    private final int segmentSize;
    private int lastSegmentAllocated;
    private int lastPage;
    private MappedByteBuffer currentPage;
    private FileChannel currentPageFile;
    private final Map<Integer, WeakReference<MappedByteBuffer>> pageCache = new HashMap<Integer, WeakReference<MappedByteBuffer>>();

    PagedFilesAllocator(Path pagesFolder, int pageSize, int segmentSize, int lastPage, int lastSegmentAllocated) throws QueueException {
        if (pageSize % segmentSize != 0) {
            throw new IllegalArgumentException("The pageSize must be an exact multiple of the segmentSize");
        }
        this.pagesFolder = pagesFolder;
        this.pageSize = pageSize;
        this.segmentSize = segmentSize;
        this.lastPage = lastPage;
        this.lastSegmentAllocated = lastSegmentAllocated;
        this.currentPage = this.openOrRetrievePageFile(this.lastPage);
    }

    private MappedByteBuffer openOrRetrievePageFile(int pageId) throws QueueException {
        MappedByteBuffer pageBuffer = null;
        WeakReference<MappedByteBuffer> pageBufferRef = this.pageCache.get(pageId);
        if (pageBufferRef != null) {
            pageBuffer = (MappedByteBuffer)pageBufferRef.get();
        }
        if (pageBuffer == null) {
            pageBuffer = this.openRWPageFile(pageId);
            pageBufferRef = new WeakReference<MappedByteBuffer>(pageBuffer);
            WeakReference<MappedByteBuffer> old = this.pageCache.put(pageId, pageBufferRef);
            if (old != null && old.get() != null) {
                LOG.warn("Page file {} opened even though it already is open!", (Object)pageId);
            }
        }
        return pageBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MappedByteBuffer openRWPageFile(int pageId) throws QueueException {
        Path pageFile = this.pagesFolder.resolve(String.format("%d.page", pageId));
        LOG.debug("Opening page {} from file {}", (Object)pageId, (Object)pageFile);
        boolean createNew = false;
        if (!Files.exists(pageFile, new LinkOption[0])) {
            try {
                pageFile.toFile().createNewFile();
                createNew = true;
            }
            catch (IOException ex) {
                throw new QueueException("Reached an IO error during the bootstrapping of empty 'checkpoint.properties'", ex);
            }
        }
        try (FileChannel fileChannel = FileChannel.open(pageFile, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            this.currentPageFile = fileChannel;
            MappedByteBuffer mappedPage = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.pageSize);
            if (createNew && QueuePool.queueDebug) {
                for (int i = 0; i < this.pageSize; ++i) {
                    mappedPage.put(i, (byte)67);
                }
            }
            MappedByteBuffer mappedByteBuffer = mappedPage;
            return mappedByteBuffer;
        }
        catch (IOException e) {
            throw new QueueException("Can't open page file " + pageFile, e);
        }
    }

    @Override
    public Segment nextFreeSegment() throws QueueException {
        if (this.currentPageIsExhausted()) {
            ++this.lastPage;
            this.currentPage = this.openOrRetrievePageFile(this.lastPage);
            this.lastSegmentAllocated = 0;
        }
        int beginOffset = this.lastSegmentAllocated * this.segmentSize;
        int endOffset = (this.lastSegmentAllocated + 1) * this.segmentSize - 1;
        ++this.lastSegmentAllocated;
        return new Segment(this.currentPage, new SegmentPointer(this.lastPage, (long)beginOffset), new SegmentPointer(this.lastPage, (long)endOffset));
    }

    @Override
    public Segment reopenSegment(int pageId, int beginOffset) throws QueueException {
        MappedByteBuffer page = this.openOrRetrievePageFile(pageId);
        SegmentPointer begin = new SegmentPointer(pageId, (long)beginOffset);
        SegmentPointer end = new SegmentPointer(pageId, (long)(beginOffset + this.segmentSize - 1));
        return new Segment(page, begin, end);
    }

    @Override
    public void close() throws QueueException {
        if (this.currentPageFile != null) {
            try {
                this.currentPageFile.close();
            }
            catch (IOException ex) {
                throw new QueueException("Problem closing current page file", ex);
            }
        }
    }

    @Override
    public void dumpState(Properties checkpoint) {
        checkpoint.setProperty("segments.last_page", String.valueOf(this.lastPage));
        checkpoint.setProperty("segments.last_segment", String.valueOf(this.lastSegmentAllocated));
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getSegmentSize() {
        return this.segmentSize;
    }

    private boolean currentPageIsExhausted() {
        return this.lastSegmentAllocated * this.segmentSize == this.pageSize;
    }

    static interface AllocationListener {
        public void segmentedCreated(String var1, Segment var2);
    }
}

