/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class Limit {
    private final Optional<Integer> value;

    public static Limit of(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"A limit need to be positive");
        return new Limit(Optional.of(value));
    }

    public static Limit unlimited() {
        return new Limit(Optional.empty());
    }

    private Limit(Optional<Integer> value) {
        this.value = value;
    }

    public Optional<Integer> getValue() {
        return this.value;
    }

    public boolean isLimited() {
        return this.value.isPresent();
    }

    public final boolean equals(Object o) {
        if (o instanceof Limit) {
            Limit limit = (Limit)o;
            return Objects.equals(this.value, limit.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }
}

