/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMappingsSourcesDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement retrieveSourcesStatement;
    private final PreparedStatement truncateStatement;

    @Inject
    public CassandraMappingsSourcesDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertStatement = this.prepareInsertStatement(session);
        this.deleteStatement = this.prepareDelete(session);
        this.retrieveSourcesStatement = this.prepareRetrieveSourcesStatement(session);
        this.truncateStatement = this.prepareTruncateStatement(session);
    }

    private PreparedStatement prepareInsertStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mappings_sources").value("mapping_type", (Object)QueryBuilder.bindMarker((String)"mapping_type")).value("mapping_value", (Object)QueryBuilder.bindMarker((String)"mapping_value")).value("source", (Object)QueryBuilder.bindMarker((String)"source")));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mappings_sources").where(QueryBuilder.eq((String)"mapping_type", (Object)QueryBuilder.bindMarker((String)"mapping_type"))).and(QueryBuilder.eq((String)"mapping_value", (Object)QueryBuilder.bindMarker((String)"mapping_value"))).and(QueryBuilder.eq((String)"source", (Object)QueryBuilder.bindMarker((String)"source"))));
    }

    private PreparedStatement prepareRetrieveSourcesStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"source"}).from("mappings_sources").where(QueryBuilder.eq((String)"mapping_type", (Object)QueryBuilder.bindMarker((String)"mapping_type"))).and(QueryBuilder.eq((String)"mapping_value", (Object)QueryBuilder.bindMarker((String)"mapping_value"))));
    }

    private PreparedStatement prepareTruncateStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.truncate((String)"mappings_sources"));
    }

    public Mono<Void> addMapping(Mapping mapping, MappingSource source) {
        return this.executor.executeVoid((Statement)this.insertStatement.bind().setString("mapping_type", mapping.getType().asPrefix()).setString("mapping_value", mapping.getMappingValue()).setString("source", source.asMailAddressString()));
    }

    Mono<Void> removeMapping(Mapping mapping, MappingSource source) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind().setString("mapping_type", mapping.getType().asPrefix()).setString("mapping_value", mapping.getMappingValue()).setString("source", source.asMailAddressString()));
    }

    public Flux<MappingSource> retrieveSources(Mapping mapping) {
        return this.executor.executeRows((Statement)this.retrieveSourcesStatement.bind().setString("mapping_type", mapping.getType().asPrefix()).setString("mapping_value", mapping.getMappingValue())).map(row -> MappingSource.parse((String)row.getString("source")));
    }

    public Mono<Void> removeAllData() {
        return this.executor.executeVoid((Statement)this.truncateStatement.bind());
    }
}

