/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.sieve.cassandra.model.Script;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraSieveDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertScriptStatement;
    private final PreparedStatement selectScriptsStatement;
    private final PreparedStatement selectScriptStatement;
    private final PreparedStatement updateScriptActivationStatement;
    private final PreparedStatement deleteScriptStatement;

    @Inject
    public CassandraSieveDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insertScriptStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"sieve").value("user_name", (Object)QueryBuilder.bindMarker((String)"user_name")).value("script_name", (Object)QueryBuilder.bindMarker((String)"script_name")).value("script_content", (Object)QueryBuilder.bindMarker((String)"script_content")).value("is_active", (Object)QueryBuilder.bindMarker((String)"is_active")).value("size", (Object)QueryBuilder.bindMarker((String)"size")));
        this.selectScriptsStatement = session.prepare((RegularStatement)this.getScriptsQuery());
        this.selectScriptStatement = session.prepare((RegularStatement)this.getScriptsQuery().and(QueryBuilder.eq((String)"script_name", (Object)QueryBuilder.bindMarker((String)"script_name"))));
        this.updateScriptActivationStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"sieve").with(QueryBuilder.set((String)"is_active", (Object)QueryBuilder.bindMarker((String)"is_active"))).where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))).and(QueryBuilder.eq((String)"script_name", (Object)QueryBuilder.bindMarker((String)"script_name"))).ifExists());
        this.deleteScriptStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("sieve").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))).and(QueryBuilder.eq((String)"script_name", (Object)QueryBuilder.bindMarker((String)"script_name"))).ifExists());
    }

    private Select.Where getScriptsQuery() {
        return QueryBuilder.select((String[])new String[]{"script_content", "is_active", "script_name", "size"}).from("sieve").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name")));
    }

    public Mono<Void> insertScript(Username username, Script script) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertScriptStatement.bind().setString("user_name", username.asString()).setString("script_name", script.getName().getValue()).setString("script_content", script.getContent().getValue()).setBool("is_active", script.isActive()).setLong("size", script.getSize()));
    }

    public Flux<ScriptSummary> listScripts(Username username) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectScriptsStatement.bind().setString("user_name", username.asString())).map(row -> new ScriptSummary(new ScriptName(row.getString("script_name")), row.getBool("is_active")));
    }

    public Mono<Boolean> updateScriptActivation(Username username, ScriptName scriptName, boolean active) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.updateScriptActivationStatement.bind().setString("user_name", username.asString()).setString("script_name", scriptName.getValue()).setBool("is_active", active));
    }

    public Mono<Script> getScript(Username username, ScriptName name) {
        return this.getScriptRow(username, name).map(row -> Script.builder().content(row.getString("script_content")).isActive(row.getBool("is_active")).name(name).size(row.getLong("size")).build());
    }

    public Mono<Boolean> deleteScriptInCassandra(Username username, ScriptName name) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.deleteScriptStatement.bind().setString("user_name", username.asString()).setString("script_name", name.getValue()));
    }

    private Mono<Row> getScriptRow(Username username, ScriptName name) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectScriptStatement.bind().setString("user_name", username.asString()).setString("script_name", name.getValue()));
    }
}

