/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.base.Preconditions;
import org.apache.james.jmap.http.AuthenticationChallenge;
import org.apache.james.mailbox.MailboxSession;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public interface AuthenticationStrategy {
    public static final String AUTHORIZATION_HEADERS = "Authorization";

    public Mono<MailboxSession> createMailboxSession(HttpServerRequest var1);

    public AuthenticationChallenge correspondingChallenge();

    default public String authHeaders(HttpServerRequest httpRequest) {
        Preconditions.checkArgument((httpRequest != null ? 1 : 0) != 0, (Object)"'httpRequest' is mandatory");
        Preconditions.checkArgument((httpRequest.requestHeaders().getAll(AUTHORIZATION_HEADERS).size() <= 1 ? 1 : 0) != 0, (Object)"Only one set of credential is allowed");
        return httpRequest.requestHeaders().get(AUTHORIZATION_HEADERS);
    }
}

