/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.authentication;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class JwtFilter
implements AuthenticationFilter {
    public static final String AUTHORIZATION_HEADER_PREFIX = "Bearer ";
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String OPTIONS = "OPTIONS";
    private final JwtTokenVerifier jwtTokenVerifier;

    @Inject
    public JwtFilter(@Named(value="webadmin") JwtTokenVerifier.Factory jwtTokenVerifierFactory) {
        this.jwtTokenVerifier = jwtTokenVerifierFactory.create();
    }

    public void handle(Request request, Response response) throws Exception {
        if (!request.requestMethod().equals(OPTIONS)) {
            Optional<String> bearer = Optional.ofNullable(request.headers(AUTHORIZATION_HEADER_NAME)).filter(value -> value.startsWith(AUTHORIZATION_HEADER_PREFIX)).map(value -> value.substring(AUTHORIZATION_HEADER_PREFIX.length()));
            this.checkHeaderPresent(bearer);
            String login = this.retrieveUser(bearer);
            this.checkIsAdmin(bearer);
            request.attribute("LOGIN", (Object)login);
        }
    }

    private void checkHeaderPresent(Optional<String> bearer) {
        if (!bearer.isPresent()) {
            Spark.halt((int)401, (String)"No Bearer header.");
        }
    }

    private String retrieveUser(Optional<String> bearer) {
        return (String)this.jwtTokenVerifier.verifyAndExtractLogin(bearer.get()).orElseThrow(() -> Spark.halt((int)401, (String)"Invalid Bearer header."));
    }

    private void checkIsAdmin(Optional<String> bearer) {
        if (!this.jwtTokenVerifier.hasAttribute("admin", (Object)true, bearer.get())) {
            Spark.halt((int)401, (String)"Non authorized user.");
        }
    }
}

