/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.transport.matchers.AbstractSQLWhitelistMatcher;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;

@Experimental
public class NetworkIsInWhitelist
extends AbstractSQLWhitelistMatcher {
    private DNSService dns;
    private String selectNetworks;

    @Inject
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Override
    protected String getSQLSectionName() {
        return "NetworkWhiteList";
    }

    @Override
    public void init() throws MessagingException {
        super.init();
        this.selectNetworks = this.sqlQueries.getSqlString("selectNetwork", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean matchedWhitelist(MailAddress recipientMailAddress, Mail mail) throws MessagingException {
        boolean bl;
        Connection conn = null;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        try {
            String recipientUser = recipientMailAddress.getLocalPart().toLowerCase(Locale.US);
            String recipientHost = recipientMailAddress.getDomain().asString();
            conn = this.datasource.getConnection();
            ArrayList<String> nets = new ArrayList<String>();
            try {
                selectStmt = conn.prepareStatement(this.selectNetworks);
                selectStmt.setString(1, recipientUser);
                selectStmt.setString(2, recipientHost);
                selectRS = selectStmt.executeQuery();
                while (selectRS.next()) {
                    nets.add(selectRS.getString(1));
                }
            }
            catch (Throwable throwable) {
                this.jdbcUtil.closeJDBCResultSet(selectRS);
                this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                throw throwable;
            }
            this.jdbcUtil.closeJDBCResultSet(selectRS);
            this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
            NetMatcher matcher = new NetMatcher(nets, this.dns);
            boolean matched = matcher.matchInetNetwork(mail.getRemoteAddr());
            if (!matched) {
                try {
                    selectStmt = conn.prepareStatement(this.selectNetworks);
                    selectStmt.setString(1, "*");
                    selectStmt.setString(2, recipientHost);
                    selectRS = selectStmt.executeQuery();
                    nets = new ArrayList();
                    while (selectRS.next()) {
                        nets.add(selectRS.getString(1));
                    }
                }
                finally {
                    this.jdbcUtil.closeJDBCResultSet(selectRS);
                    this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                }
                matcher = new NetMatcher(nets, this.dns);
                matched = matcher.matchInetNetwork(mail.getRemoteAddr());
            }
            bl = matched;
        }
        catch (SQLException sqle) {
            try {
                throw new MessagingException("Error accessing database", (Exception)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCConnection(conn);
        return bl;
    }

    @Override
    protected String getTableCreateQueryName() {
        return "createNetworkWhiteListTable";
    }

    @Override
    protected String getTableName() {
        return "networkWhiteListTableName";
    }
}

