/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public final class PassphraseEncryptedStreamHeader
implements Serializable {
    static final byte TYPE_ENCODING_VERSION = -128;
    static final byte TYPE_KEY_FACTORY_ALGORITHM = -127;
    static final byte TYPE_KEY_FACTORY_ITERATION_COUNT = -126;
    static final byte TYPE_KEY_FACTORY_SALT = -125;
    static final byte TYPE_KEY_FACTORY_KEY_LENGTH_BITS = -124;
    static final byte TYPE_CIPHER_TRANSFORMATION = -123;
    static final byte TYPE_CIPHER_INITIALIZATION_VECTOR = -122;
    static final byte TYPE_KEY_IDENTIFIER = -121;
    static final byte TYPE_MAC_ALGORITHM = -120;
    static final byte TYPE_MAC_VALUE = -119;
    @NotNull
    public static final byte[] MAGIC_BYTES = new byte[]{80, 85, 76, 83, 80, 69, 83, 72};
    static final int ENCODING_VERSION_1 = 1;
    private static final long serialVersionUID = 6756983626170064762L;
    @NotNull
    private final byte[] cipherInitializationVector;
    @NotNull
    private final byte[] encodedHeader;
    @NotNull
    private final byte[] keyFactorySalt;
    @NotNull
    private final byte[] macValue;
    private final int keyFactoryIterationCount;
    private final int keyFactoryKeyLengthBits;
    @Nullable
    private final SecretKey secretKey;
    @NotNull
    private final String cipherTransformation;
    @NotNull
    private final String keyFactoryAlgorithm;
    @Nullable
    private final String keyIdentifier;
    @NotNull
    private final String macAlgorithm;

    private PassphraseEncryptedStreamHeader(@NotNull String keyFactoryAlgorithm, int keyFactoryIterationCount, @NotNull byte[] keyFactorySalt, int keyFactoryKeyLengthBits, @NotNull String cipherTransformation, @NotNull byte[] cipherInitializationVector, @Nullable String keyIdentifier, @Nullable SecretKey secretKey, @NotNull String macAlgorithm, @NotNull byte[] macValue, @NotNull byte[] encodedHeader) {
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.keyFactoryIterationCount = keyFactoryIterationCount;
        this.keyFactorySalt = Arrays.copyOf(keyFactorySalt, keyFactorySalt.length);
        this.keyFactoryKeyLengthBits = keyFactoryKeyLengthBits;
        this.cipherTransformation = cipherTransformation;
        this.cipherInitializationVector = Arrays.copyOf(cipherInitializationVector, cipherInitializationVector.length);
        this.keyIdentifier = keyIdentifier;
        this.secretKey = secretKey;
        this.macAlgorithm = macAlgorithm;
        this.macValue = macValue;
        this.encodedHeader = encodedHeader;
    }

    PassphraseEncryptedStreamHeader(@NotNull char[] passphrase, @NotNull String keyFactoryAlgorithm, int keyFactoryIterationCount, @NotNull byte[] keyFactorySalt, int keyFactoryKeyLengthBits, @NotNull String cipherTransformation, @NotNull byte[] cipherInitializationVector, @Nullable String keyIdentifier, @NotNull String macAlgorithm) throws GeneralSecurityException {
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.keyFactoryIterationCount = keyFactoryIterationCount;
        this.keyFactorySalt = Arrays.copyOf(keyFactorySalt, keyFactorySalt.length);
        this.keyFactoryKeyLengthBits = keyFactoryKeyLengthBits;
        this.cipherTransformation = cipherTransformation;
        this.cipherInitializationVector = Arrays.copyOf(cipherInitializationVector, cipherInitializationVector.length);
        this.keyIdentifier = keyIdentifier;
        this.macAlgorithm = macAlgorithm;
        this.secretKey = PassphraseEncryptedStreamHeader.generateKeyReliably(keyFactoryAlgorithm, cipherTransformation, passphrase, keyFactorySalt, keyFactoryIterationCount, keyFactoryKeyLengthBits);
        ObjectPair<byte[], byte[]> headerPair = PassphraseEncryptedStreamHeader.encode(keyFactoryAlgorithm, keyFactoryIterationCount, this.keyFactorySalt, keyFactoryKeyLengthBits, cipherTransformation, this.cipherInitializationVector, keyIdentifier, this.secretKey, macAlgorithm);
        this.encodedHeader = headerPair.getFirst();
        this.macValue = headerPair.getSecond();
    }

    @NotNull
    private static ObjectPair<byte[], byte[]> encode(@NotNull String keyFactoryAlgorithm, int keyFactoryIterationCount, @NotNull byte[] keyFactorySalt, int keyFactoryKeyLengthBits, @NotNull String cipherTransformation, @NotNull byte[] cipherInitializationVector, @Nullable String keyIdentifier, @Nullable SecretKey secretKey, @NotNull String macAlgorithm) throws GeneralSecurityException {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(10);
        elements.add(new ASN1Integer(-128, 1));
        elements.add(new ASN1OctetString(-127, keyFactoryAlgorithm));
        elements.add(new ASN1Integer(-126, keyFactoryIterationCount));
        elements.add(new ASN1OctetString(-125, keyFactorySalt));
        elements.add(new ASN1Integer(-124, keyFactoryKeyLengthBits));
        elements.add(new ASN1OctetString(-123, cipherTransformation));
        elements.add(new ASN1OctetString(-122, cipherInitializationVector));
        if (keyIdentifier != null) {
            elements.add(new ASN1OctetString(-121, keyIdentifier));
        }
        elements.add(new ASN1OctetString(-120, macAlgorithm));
        ByteStringBuffer macBuffer = new ByteStringBuffer();
        for (ASN1Element e : elements) {
            macBuffer.append(e.encode());
        }
        Mac mac = CryptoHelper.getMAC(macAlgorithm);
        mac.init(secretKey);
        byte[] macValue = mac.doFinal(macBuffer.toByteArray());
        elements.add(new ASN1OctetString(-119, macValue));
        byte[] elementBytes = new ASN1Sequence(elements).encode();
        byte[] headerBytes = new byte[MAGIC_BYTES.length + elementBytes.length];
        System.arraycopy(MAGIC_BYTES, 0, headerBytes, 0, MAGIC_BYTES.length);
        System.arraycopy(elementBytes, 0, headerBytes, MAGIC_BYTES.length, elementBytes.length);
        return new ObjectPair<byte[], byte[]>(headerBytes, macValue);
    }

    public void writeTo(@NotNull OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedHeader);
    }

    @NotNull
    public static PassphraseEncryptedStreamHeader readFrom(@NotNull InputStream inputStream, @Nullable char[] passphrase) throws IOException, LDAPException, InvalidKeyException, GeneralSecurityException {
        for (int i = 0; i < MAGIC_BYTES.length; ++i) {
            int magicByte = inputStream.read();
            if (magicByte < 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_READ_END_OF_STREAM_IN_MAGIC.get());
            }
            if (magicByte == MAGIC_BYTES[i]) continue;
            throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_READ_MAGIC_MISMATCH.get());
        }
        try {
            ASN1Element headerSequenceElement = ASN1Element.readFrom(inputStream);
            if (headerSequenceElement == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_READ_END_OF_STREAM_AFTER_MAGIC.get());
            }
            byte[] encodedHeaderSequence = headerSequenceElement.encode();
            byte[] encodedHeader = new byte[MAGIC_BYTES.length + encodedHeaderSequence.length];
            System.arraycopy(MAGIC_BYTES, 0, encodedHeader, 0, MAGIC_BYTES.length);
            System.arraycopy(encodedHeaderSequence, 0, encodedHeader, MAGIC_BYTES.length, encodedHeaderSequence.length);
            ASN1Sequence headerSequence = ASN1Sequence.decodeAsSequence(headerSequenceElement);
            return PassphraseEncryptedStreamHeader.decodeHeaderSequence(encodedHeader, headerSequence, passphrase);
        }
        catch (LDAPException | IOException | GeneralSecurityException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_READ_ASN1_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static PassphraseEncryptedStreamHeader decode(@NotNull byte[] encodedHeader, @Nullable char[] passphrase) throws LDAPException, InvalidKeyException, GeneralSecurityException {
        ASN1Sequence headerSequence;
        if (encodedHeader.length <= MAGIC_BYTES.length) {
            throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_DECODE_TOO_SHORT.get());
        }
        for (int i = 0; i < MAGIC_BYTES.length; ++i) {
            if (encodedHeader[i] == MAGIC_BYTES[i]) continue;
            throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_DECODE_MAGIC_MISMATCH.get());
        }
        try {
            byte[] encodedHeaderWithoutMagic = new byte[encodedHeader.length - MAGIC_BYTES.length];
            System.arraycopy(encodedHeader, MAGIC_BYTES.length, encodedHeaderWithoutMagic, 0, encodedHeaderWithoutMagic.length);
            headerSequence = ASN1Sequence.decodeAsSequence(encodedHeaderWithoutMagic);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_DECODE_ASN1_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
        return PassphraseEncryptedStreamHeader.decodeHeaderSequence(encodedHeader, headerSequence, passphrase);
    }

    @NotNull
    private static PassphraseEncryptedStreamHeader decodeHeaderSequence(@NotNull byte[] encodedHeader, @NotNull ASN1Sequence headerSequence, @Nullable char[] passphrase) throws LDAPException, InvalidKeyException, GeneralSecurityException {
        try {
            SecretKey secretKey;
            ASN1Element[] headerElements = headerSequence.elements();
            ASN1Integer versionElement = ASN1Integer.decodeAsInteger(headerElements[0]);
            if (versionElement.intValue() != 1) {
                throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_HEADER_SEQUENCE_UNSUPPORTED_VERSION.get(versionElement.intValue()));
            }
            String keyFactoryAlgorithm = ASN1OctetString.decodeAsOctetString(headerElements[1]).stringValue();
            int keyFactoryIterationCount = ASN1Integer.decodeAsInteger(headerElements[2]).intValue();
            byte[] keyFactorySalt = ASN1OctetString.decodeAsOctetString(headerElements[3]).getValue();
            int keyFactoryKeyLengthBits = ASN1Integer.decodeAsInteger(headerElements[4]).intValue();
            String cipherTransformation = ASN1OctetString.decodeAsOctetString(headerElements[5]).stringValue();
            byte[] cipherInitializationVector = ASN1OctetString.decodeAsOctetString(headerElements[6]).getValue();
            byte[] macValue = null;
            int macValuePos = -1;
            String keyIdentifier = null;
            String macAlgorithm = null;
            block8: for (int i = 7; i < headerElements.length; ++i) {
                switch (headerElements[i].getType()) {
                    case -121: {
                        keyIdentifier = ASN1OctetString.decodeAsOctetString(headerElements[i]).stringValue();
                        continue block8;
                    }
                    case -120: {
                        macAlgorithm = ASN1OctetString.decodeAsOctetString(headerElements[i]).stringValue();
                        continue block8;
                    }
                    case -119: {
                        macValuePos = i;
                        macValue = ASN1OctetString.decodeAsOctetString(headerElements[i]).getValue();
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_HEADER_SEQUENCE_UNRECOGNIZED_ELEMENT_TYPE.get(StaticUtils.toHex(headerElements[i].getType())));
                    }
                }
            }
            if (passphrase == null) {
                secretKey = null;
            } else {
                secretKey = PassphraseEncryptedStreamHeader.generateKeyReliably(keyFactoryAlgorithm, cipherTransformation, passphrase, keyFactorySalt, keyFactoryIterationCount, keyFactoryKeyLengthBits);
                ByteStringBuffer macBuffer = new ByteStringBuffer();
                for (int i = 0; i < headerElements.length; ++i) {
                    if (i == macValuePos) continue;
                    macBuffer.append(headerElements[i].encode());
                }
                Mac mac = CryptoHelper.getMAC(macAlgorithm);
                mac.init(secretKey);
                byte[] computedMacValue = mac.doFinal(macBuffer.toByteArray());
                if (!Arrays.equals(computedMacValue, macValue)) {
                    throw new InvalidKeyException(UtilityMessages.ERR_PW_ENCRYPTED_HEADER_SEQUENCE_BAD_PW.get());
                }
            }
            return new PassphraseEncryptedStreamHeader(keyFactoryAlgorithm, keyFactoryIterationCount, keyFactorySalt, keyFactoryKeyLengthBits, cipherTransformation, cipherInitializationVector, keyIdentifier, secretKey, macAlgorithm, macValue, encodedHeader);
        }
        catch (LDAPException | GeneralSecurityException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_PW_ENCRYPTED_HEADER_SEQUENCE_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static SecretKey generateKeyReliably(@NotNull String keyFactoryAlgorithm, @NotNull String cipherTransformation, @NotNull char[] passphrase, @NotNull byte[] keyFactorySalt, int keyFactoryIterationCount, int keyFactoryKeyLengthBits) throws GeneralSecurityException {
        byte[] prev = null;
        byte[] prev2 = null;
        int iterations = 10;
        for (int i = 0; i < 10; ++i) {
            SecretKeyFactory keyFactory = CryptoHelper.getSecretKeyFactory(keyFactoryAlgorithm);
            String cipherAlgorithm = cipherTransformation.substring(0, cipherTransformation.indexOf(47));
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase, keyFactorySalt, keyFactoryIterationCount, keyFactoryKeyLengthBits);
            SecretKeySpec secretKey = new SecretKeySpec(keyFactory.generateSecret(pbeKeySpec).getEncoded(), cipherAlgorithm);
            byte[] encoded = secretKey.getEncoded();
            if (Arrays.equals(encoded, prev) && Arrays.equals(encoded, prev2)) {
                if (i > 2) {
                    Debug.debug(Level.WARNING, DebugType.OTHER, "The secret key was generated inconsistently initially, but after " + i + " iterations, we were able to generate a " + "consistent value.");
                }
                return secretKey;
            }
            prev2 = prev;
            prev = encoded;
        }
        Debug.debug(Level.SEVERE, DebugType.OTHER, "Even after 10 iterations, the secret key could not be reliably generated.");
        throw new InvalidKeyException(UtilityMessages.ERR_PW_ENCRYPTED_STREAM_HEADER_CANNOT_GENERATE_KEY.get());
    }

    @NotNull
    Cipher createCipher(int mode) throws InvalidKeyException, GeneralSecurityException {
        if (this.secretKey == null) {
            throw new InvalidKeyException(UtilityMessages.ERR_PW_ENCRYPTED_HEADER_NO_KEY_AVAILABLE.get());
        }
        Cipher cipher = CryptoHelper.getCipher(this.cipherTransformation);
        cipher.init(mode, (Key)this.secretKey, new IvParameterSpec(this.cipherInitializationVector));
        return cipher;
    }

    @NotNull
    public String getKeyFactoryAlgorithm() {
        return this.keyFactoryAlgorithm;
    }

    public int getKeyFactoryIterationCount() {
        return this.keyFactoryIterationCount;
    }

    @NotNull
    public byte[] getKeyFactorySalt() {
        return Arrays.copyOf(this.keyFactorySalt, this.keyFactorySalt.length);
    }

    public int getKeyFactoryKeyLengthBits() {
        return this.keyFactoryKeyLengthBits;
    }

    @NotNull
    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    @NotNull
    public byte[] getCipherInitializationVector() {
        return Arrays.copyOf(this.cipherInitializationVector, this.cipherInitializationVector.length);
    }

    @Nullable
    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    @NotNull
    public String getMACAlgorithm() {
        return this.macAlgorithm;
    }

    @NotNull
    public byte[] getEncodedHeader() {
        return Arrays.copyOf(this.encodedHeader, this.encodedHeader.length);
    }

    public boolean isSecretKeyAvailable() {
        return this.secretKey != null;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PassphraseEncryptedStreamHeader(keyFactoryAlgorithm='");
        buffer.append(this.keyFactoryAlgorithm);
        buffer.append("', keyFactoryIterationCount=");
        buffer.append(this.keyFactoryIterationCount);
        buffer.append(", keyFactorySaltLengthBytes=");
        buffer.append(this.keyFactorySalt.length);
        buffer.append(", keyFactoryKeyLengthBits=");
        buffer.append(this.keyFactoryKeyLengthBits);
        buffer.append(", cipherTransformation'=");
        buffer.append(this.cipherTransformation);
        buffer.append("', cipherInitializationVectorLengthBytes=");
        buffer.append(this.cipherInitializationVector.length);
        buffer.append('\'');
        if (this.keyIdentifier != null) {
            buffer.append(", keyIdentifier='");
            buffer.append(this.keyIdentifier);
            buffer.append('\'');
        }
        buffer.append(", macAlgorithm='");
        buffer.append(this.macAlgorithm);
        buffer.append("', macValueLengthBytes=");
        buffer.append(this.macValue.length);
        buffer.append(", secretKeyAvailable=");
        buffer.append(this.isSecretKeyAvailable());
        buffer.append(", encodedHeaderLengthBytes=");
        buffer.append(this.encodedHeader.length);
        buffer.append(')');
    }
}

