/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SuppressOperationalAttributeUpdateRequestControl
extends Control {
    @NotNull
    public static final String SUPPRESS_OP_ATTR_UPDATE_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.27";
    private static final byte TYPE_SUPPRESS_TYPES = -128;
    @NotNull
    private static final String JSON_FIELD_SUPPRESS_TYPES = "suppress-types";
    @NotNull
    private static final String JSON_SUPPRESS_TYPE_LAST_ACCESS_TIME = "last-access-time";
    @NotNull
    private static final String JSON_SUPPRESS_TYPE_LAST_LOGIN_IP_ADDRESS = "last-login-ip-address";
    @NotNull
    private static final String JSON_SUPPRESS_TYPE_LAST_LOGIN_TIME = "last-login-time";
    @NotNull
    private static final String JSON_SUPPRESS_TYPE_LASTMOD = "lastmod";
    private static final long serialVersionUID = 4603958484615351672L;
    @NotNull
    private final Set<SuppressType> suppressTypes;

    public SuppressOperationalAttributeUpdateRequestControl(SuppressType ... suppressTypes) {
        this(false, suppressTypes);
    }

    public SuppressOperationalAttributeUpdateRequestControl(@NotNull Collection<SuppressType> suppressTypes) {
        this(false, suppressTypes);
    }

    public SuppressOperationalAttributeUpdateRequestControl(boolean isCritical, SuppressType ... suppressTypes) {
        this(isCritical, Arrays.asList(suppressTypes));
    }

    public SuppressOperationalAttributeUpdateRequestControl(boolean isCritical, @NotNull Collection<SuppressType> suppressTypes) {
        super(SUPPRESS_OP_ATTR_UPDATE_REQUEST_OID, isCritical, SuppressOperationalAttributeUpdateRequestControl.encodeValue(suppressTypes));
        Validator.ensureFalse(suppressTypes.isEmpty());
        EnumSet<SuppressType> s = EnumSet.noneOf(SuppressType.class);
        for (SuppressType t : suppressTypes) {
            s.add(t);
        }
        this.suppressTypes = Collections.unmodifiableSet(s);
    }

    public SuppressOperationalAttributeUpdateRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_MISSING_VALUE.get());
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            ASN1Sequence suppressTypesSequence = ASN1Sequence.decodeAsSequence(valueSequence.elements()[0]);
            EnumSet<SuppressType> s = EnumSet.noneOf(SuppressType.class);
            for (ASN1Element e : suppressTypesSequence.elements()) {
                ASN1Enumerated ae = ASN1Enumerated.decodeAsEnumerated(e);
                SuppressType t = SuppressType.valueOf(ae.intValue());
                if (t == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UNRECOGNIZED_SUPPRESS_TYPE.get(ae.intValue()));
                }
                s.add(t);
            }
            this.suppressTypes = Collections.unmodifiableSet(s);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull Collection<SuppressType> suppressTypes) {
        ArrayList<ASN1Enumerated> suppressTypeElements = new ArrayList<ASN1Enumerated>(suppressTypes.size());
        for (SuppressType t : suppressTypes) {
            suppressTypeElements.add(new ASN1Enumerated(t.intValue()));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1Sequence(-128, suppressTypeElements));
        return new ASN1OctetString(valueSequence.encode());
    }

    @NotNull
    public Set<SuppressType> getSuppressTypes() {
        return this.suppressTypes;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SUPPRESS_OP_ATTR_UPDATE_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        ArrayList<JSONString> suppressTypeValues = new ArrayList<JSONString>(this.suppressTypes.size());
        for (SuppressType suppressType : this.suppressTypes) {
            switch (suppressType) {
                case LAST_ACCESS_TIME: {
                    suppressTypeValues.add(new JSONString(JSON_SUPPRESS_TYPE_LAST_ACCESS_TIME));
                    break;
                }
                case LAST_LOGIN_TIME: {
                    suppressTypeValues.add(new JSONString(JSON_SUPPRESS_TYPE_LAST_LOGIN_TIME));
                    break;
                }
                case LAST_LOGIN_IP: {
                    suppressTypeValues.add(new JSONString(JSON_SUPPRESS_TYPE_LAST_LOGIN_IP_ADDRESS));
                    break;
                }
                case LASTMOD: {
                    suppressTypeValues.add(new JSONString(JSON_SUPPRESS_TYPE_LASTMOD));
                }
            }
        }
        return new JSONObject(new JSONField("oid", SUPPRESS_OP_ATTR_UPDATE_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SUPPRESS_OP_ATTR_UPDATE_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_SUPPRESS_TYPES, new JSONArray(suppressTypeValues)))));
    }

    @NotNull
    public static SuppressOperationalAttributeUpdateRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawvalue = jsonControl.getRawValue();
        if (rawvalue != null) {
            return new SuppressOperationalAttributeUpdateRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawvalue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        List<JSONValue> suppressTypeValues = valueObject.getFieldAsArray(JSON_FIELD_SUPPRESS_TYPES);
        if (suppressTypeValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_JSON_MISSING_SUPPRESS_TYPES.get(controlObject.toSingleLineString(), JSON_FIELD_SUPPRESS_TYPES));
        }
        if (suppressTypeValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_JSON_EMPTY_SUPPRESS_TYPES.get(controlObject.toSingleLineString(), JSON_FIELD_SUPPRESS_TYPES));
        }
        EnumSet<SuppressType> suppressTypes = EnumSet.noneOf(SuppressType.class);
        for (JSONValue suppressTypeValue : suppressTypeValues) {
            if (suppressTypeValue instanceof JSONString) {
                String suppressTypeString;
                switch (suppressTypeString = ((JSONString)suppressTypeValue).stringValue()) {
                    case "last-access-time": {
                        suppressTypes.add(SuppressType.LAST_ACCESS_TIME);
                        break;
                    }
                    case "last-login-time": {
                        suppressTypes.add(SuppressType.LAST_LOGIN_TIME);
                        break;
                    }
                    case "last-login-ip-address": {
                        suppressTypes.add(SuppressType.LAST_LOGIN_IP);
                        break;
                    }
                    case "lastmod": {
                        suppressTypes.add(SuppressType.LASTMOD);
                        break;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_JSON_UNKNOWN_SUPPRESS_TYPE.get(controlObject.toSingleLineString(), JSON_FIELD_SUPPRESS_TYPES, JSON_SUPPRESS_TYPE_LAST_ACCESS_TIME, JSON_SUPPRESS_TYPE_LAST_LOGIN_TIME, JSON_SUPPRESS_TYPE_LAST_LOGIN_IP_ADDRESS, JSON_SUPPRESS_TYPE_LASTMOD));
                    }
                }
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_JSON_SUPPRESS_TYPE_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_SUPPRESS_TYPES));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SUPPRESS_TYPES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new SuppressOperationalAttributeUpdateRequestControl(jsonControl.getCriticality(), suppressTypes);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SuppressOperationalAttributeUpdateRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", suppressTypes={");
        Iterator<SuppressType> iterator = this.suppressTypes.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().name());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

