/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.BlobManager;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.message.view.MessageHeaderView;
import org.apache.james.jmap.draft.model.message.view.MessageViewFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageHeaderViewFactory
implements MessageViewFactory<MessageHeaderView> {
    private final BlobManager blobManager;
    private final MessageIdManager messageIdManager;

    @Inject
    @VisibleForTesting
    public MessageHeaderViewFactory(BlobManager blobManager, MessageIdManager messageIdManager) {
        this.blobManager = blobManager;
        this.messageIdManager = messageIdManager;
    }

    @Override
    public Flux<MessageHeaderView> fromMessageIds(List<MessageId> messageIds, MailboxSession mailboxSession) {
        Flux messages = Flux.from((Publisher)this.messageIdManager.getMessagesReactive(messageIds, FetchGroup.HEADERS, mailboxSession));
        return MessageViewFactory.Helpers.toMessageViews((Flux<MessageResult>)messages, this::fromMessageResults);
    }

    private Mono<MessageHeaderView> fromMessageResults(Collection<MessageResult> messageResults) {
        MessageViewFactory.Helpers.assertOneMessageId(messageResults);
        return Mono.fromCallable(() -> (MessageResult)messageResults.iterator().next()).flatMap((Function)Throwing.function(firstMessageResult -> {
            Set<MailboxId> mailboxIds = MessageViewFactory.Helpers.getMailboxIds(messageResults);
            Message mimeMessage = MessageViewFactory.Helpers.parse(firstMessageResult.getFullContent().getInputStream());
            return this.instanciateHeaderView(messageResults, (MessageResult)firstMessageResult, (Collection<MailboxId>)mailboxIds, mimeMessage);
        }));
    }

    private Mono<MessageHeaderView> instanciateHeaderView(Collection<MessageResult> messageResults, MessageResult firstMessageResult, Collection<MailboxId> mailboxIds, Message mimeMessage) {
        return Mono.just((Object)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)((MessageHeaderView.Builder)MessageHeaderView.messageHeaderBuilder().id(firstMessageResult.getMessageId())).mailboxIds(mailboxIds)).blobId(BlobId.of(firstMessageResult.getMessageId()))).threadId(firstMessageResult.getMessageId().serialize())).keywords(MessageViewFactory.Helpers.getKeywords(messageResults))).size(firstMessageResult.getSize())).inReplyToMessageId(MessageViewFactory.Helpers.getHeaderValue(mimeMessage, "in-reply-to"))).subject(Strings.nullToEmpty((String)mimeMessage.getSubject()).trim())).headers(MessageViewFactory.Helpers.toHeaderMap(mimeMessage.getHeader()))).from(Emailer.firstFromMailboxList(mimeMessage.getFrom()))).to(Emailer.fromAddressList(mimeMessage.getTo()))).cc(Emailer.fromAddressList(mimeMessage.getCc()))).bcc(Emailer.fromAddressList(mimeMessage.getBcc()))).replyTo(Emailer.fromAddressList(mimeMessage.getReplyTo()))).date(MessageViewFactory.Helpers.getDateFromHeaderOrInternalDateOtherwise(mimeMessage, firstMessageResult))).build());
    }
}

