/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderDomainIs
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderDomainIs.class);
    private Collection<Domain> senderDomains;

    public void init() {
        String condition = this.getCondition();
        Preconditions.checkNotNull((Object)condition, (Object)"'condition' should not be null");
        this.senderDomains = this.parseDomainsList(condition);
    }

    @VisibleForTesting
    Collection<Domain> parseDomainsList(String condition) {
        return (Collection)Splitter.onPattern((String)"(, |,| )").omitEmptyStrings().splitToStream((CharSequence)condition).map(Domain::of).collect(ImmutableList.toImmutableList());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        try {
            MaybeSender maybeSender = mail.getMaybeSender();
            if (maybeSender.asOptional().map(MailAddress::getDomain).map(this.senderDomains::contains).orElse(false).booleanValue()) {
                return mail.getRecipients();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception happened while finding sender domain match", (Throwable)e);
        }
        return ImmutableList.of();
    }
}

