/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.Cpu;
import org.opensearch.client.opensearch.nodes.ExtendedMemoryStats;
import org.opensearch.client.opensearch.nodes.MemoryStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class OperatingSystem
implements JsonpSerializable {
    private final Cpu cpu;
    private final ExtendedMemoryStats mem;
    private final MemoryStats swap;
    private final long timestamp;
    public static final JsonpDeserializer<OperatingSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystem::setupOperatingSystemDeserializer);

    private OperatingSystem(Builder builder) {
        this.cpu = ApiTypeHelper.requireNonNull(builder.cpu, this, "cpu");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.swap = ApiTypeHelper.requireNonNull(builder.swap, this, "swap");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static OperatingSystem of(Function<Builder, ObjectBuilder<OperatingSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Cpu cpu() {
        return this.cpu;
    }

    public final ExtendedMemoryStats mem() {
        return this.mem;
    }

    public final MemoryStats swap() {
        return this.swap;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu");
        this.cpu.serialize(generator, mapper);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("swap");
        this.swap.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupOperatingSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, Cpu._DESERIALIZER, "cpu");
        op.add(Builder::mem, ExtendedMemoryStats._DESERIALIZER, "mem");
        op.add(Builder::swap, MemoryStats._DESERIALIZER, "swap");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<OperatingSystem> {
        private Cpu cpu;
        private ExtendedMemoryStats mem;
        private MemoryStats swap;
        private Long timestamp;

        public final Builder cpu(Cpu value) {
            this.cpu = value;
            return this;
        }

        public final Builder cpu(Function<Cpu.Builder, ObjectBuilder<Cpu>> fn) {
            return this.cpu(fn.apply(new Cpu.Builder()).build());
        }

        public final Builder mem(ExtendedMemoryStats value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<ExtendedMemoryStats.Builder, ObjectBuilder<ExtendedMemoryStats>> fn) {
            return this.mem(fn.apply(new ExtendedMemoryStats.Builder()).build());
        }

        public final Builder swap(MemoryStats value) {
            this.swap = value;
            return this;
        }

        public final Builder swap(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.swap(fn.apply(new MemoryStats.Builder()).build());
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public OperatingSystem build() {
            this._checkSingleUse();
            return new OperatingSystem(this);
        }
    }
}

