/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.aws;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.client.transport.aws.AsyncCapturingSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;

final class AsyncCapturingResponseHandler
implements SdkAsyncHttpResponseHandler {
    private final CompletableFuture<SdkHttpResponse> responseFuture;
    private final AsyncCapturingSubscriber bodySubscriber = new AsyncCapturingSubscriber();
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    AsyncCapturingResponseHandler() {
        this.responseFuture = new CompletableFuture();
    }

    public CompletableFuture<SdkHttpResponse> getHeaderPromise() {
        return this.responseFuture;
    }

    public CompletableFuture<byte[]> getBodyPromise() {
        return this.bodySubscriber.getPromise();
    }

    public void onHeaders(SdkHttpResponse response) {
        this.responseFuture.complete(response);
    }

    public void onStream(Publisher<ByteBuffer> publisher) {
        if (!this.subscribed.getAndSet(true)) {
            publisher.subscribe((Subscriber)this.bodySubscriber);
        }
    }

    public void onError(Throwable e) {
        this.responseFuture.completeExceptionally(e);
    }
}

