/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import jakarta.inject.Inject;
import java.time.Duration;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ObjectStorageHealthCheck
implements HealthCheck {
    private static final Integer HEALTH_CHECK_TIMEOUT = 10;
    private static final ComponentName COMPONENT_NAME = new ComponentName("ObjectStorage");
    private final BlobStoreDAO blobStoreDAO;

    @Inject
    public ObjectStorageHealthCheck(BlobStoreDAO blobStoreDAO) {
        this.blobStoreDAO = blobStoreDAO;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Flux.from(this.blobStoreDAO.listBuckets()).timeout(Duration.ofSeconds(HEALTH_CHECK_TIMEOUT.intValue())).next().thenReturn((Object)Result.healthy((ComponentName)COMPONENT_NAME)).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error checking ObjectSotrage", (Throwable)e)));
    }
}

