/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.map;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class MapBasedDriverExecutionProfile
implements DriverExecutionProfile {
    private final String profileName;
    private final Map<DriverOption, Object> profile;
    private final Map<DriverOption, Object> defaultProfile;

    public MapBasedDriverExecutionProfile(Map<String, Map<DriverOption, Object>> optionsMap, String profileName) {
        this(profileName, optionsMap.get(profileName), profileName.equals("default") ? Collections.emptyMap() : optionsMap.get("default"));
        Preconditions.checkArgument((boolean)optionsMap.containsKey(profileName), (String)"Unknown profile '%s'. Check your configuration.", (Object)profileName);
    }

    public MapBasedDriverExecutionProfile(String profileName, Map<DriverOption, Object> profile, Map<DriverOption, Object> defaultProfile) {
        this.profileName = profileName;
        this.profile = profile;
        this.defaultProfile = defaultProfile;
    }

    @Override
    @NonNull
    public String getName() {
        return this.profileName;
    }

    @Override
    public boolean isDefined(@NonNull DriverOption option) {
        return this.profile.containsKey(option) || this.defaultProfile.containsKey(option);
    }

    @NonNull
    private <T> T get(@NonNull DriverOption option) {
        Object value = this.profile.getOrDefault(option, this.defaultProfile.get(option));
        if (value == null) {
            throw new IllegalArgumentException("Missing configuration option " + option.getPath());
        }
        return (T)value;
    }

    @Override
    public boolean getBoolean(@NonNull DriverOption option) {
        return (Boolean)this.get(option);
    }

    @Override
    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    public int getInt(@NonNull DriverOption option) {
        return (Integer)this.get(option);
    }

    @Override
    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    public long getLong(@NonNull DriverOption option) {
        return (Long)this.get(option);
    }

    @Override
    @NonNull
    public List<Long> getLongList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    public double getDouble(@NonNull DriverOption option) {
        return (Double)this.get(option);
    }

    @Override
    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public String getString(@NonNull DriverOption option) {
        return (String)this.get(option);
    }

    @Override
    @NonNull
    public List<String> getStringList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption option) {
        return (Map)this.get(option);
    }

    @Override
    public long getBytes(@NonNull DriverOption option) {
        return (Long)this.get(option);
    }

    @Override
    @NonNull
    public List<Long> getBytesList(DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public Duration getDuration(@NonNull DriverOption option) {
        return (Duration)this.get(option);
    }

    @Override
    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Map.Entry.comparingByKey());
        for (Map backingMap : ImmutableList.of(this.profile, this.defaultProfile)) {
            for (Map.Entry entry : backingMap.entrySet()) {
                builder.add(new AbstractMap.SimpleEntry(((DriverOption)entry.getKey()).getPath(), entry.getValue()));
            }
        }
        return builder.build();
    }
}

