/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jgroups.util.Util;

public interface SocketFactory {
    public Socket createSocket(String var1) throws IOException;

    public Socket createSocket(String var1, String var2, int var3) throws IOException;

    public Socket createSocket(String var1, InetAddress var2, int var3) throws IOException;

    public Socket createSocket(String var1, String var2, int var3, InetAddress var4, int var5) throws IOException;

    public Socket createSocket(String var1, InetAddress var2, int var3, InetAddress var4, int var5) throws IOException;

    public ServerSocket createServerSocket(String var1) throws IOException;

    public ServerSocket createServerSocket(String var1, int var2) throws IOException;

    public ServerSocket createServerSocket(String var1, int var2, int var3) throws IOException;

    public ServerSocket createServerSocket(String var1, int var2, int var3, InetAddress var4) throws IOException;

    default public SocketChannel createSocketChannel(String service_name) throws IOException {
        return SocketChannel.open();
    }

    default public SocketChannel createSocketChannel(String service_name, SocketAddress bindAddr) throws IOException {
        return this.createSocketChannel(service_name).bind(bindAddr);
    }

    default public ServerSocketChannel createServerSocketChannel(String service_name) throws IOException {
        return ServerSocketChannel.open();
    }

    default public ServerSocketChannel createServerSocketChannel(String service_name, int port) throws IOException {
        return this.createServerSocketChannel(service_name).bind(new InetSocketAddress(port));
    }

    default public ServerSocketChannel createServerSocketChannel(String service_name, int port, int backlog) throws IOException {
        return this.createServerSocketChannel(service_name).bind(new InetSocketAddress(port), backlog);
    }

    default public ServerSocketChannel createServerSocketChannel(String service_name, int port, int backlog, InetAddress bindAddr) throws IOException {
        return this.createServerSocketChannel(service_name).bind(new InetSocketAddress(bindAddr, port), backlog);
    }

    public DatagramSocket createDatagramSocket(String var1) throws SocketException;

    public DatagramSocket createDatagramSocket(String var1, SocketAddress var2) throws SocketException;

    public DatagramSocket createDatagramSocket(String var1, int var2) throws SocketException;

    public DatagramSocket createDatagramSocket(String var1, int var2, InetAddress var3) throws SocketException;

    public MulticastSocket createMulticastSocket(String var1) throws IOException;

    public MulticastSocket createMulticastSocket(String var1, int var2) throws IOException;

    public MulticastSocket createMulticastSocket(String var1, SocketAddress var2) throws IOException;

    public void close(Socket var1) throws IOException;

    public void close(ServerSocket var1) throws IOException;

    public void close(DatagramSocket var1);

    default public void close(SocketChannel channel) {
        Util.close((Closeable)channel);
    }

    default public void close(ServerSocketChannel channel) {
        Util.close((Closeable)channel);
    }
}

