/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.core.ConnectionDescription;
import org.apache.james.core.ConnectionDescriptionSupplier;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.PingMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.EventSourceOptions;
import org.apache.james.jmap.routes.EventSourceOptionsFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import play.api.libs.json.Json$;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\n\u0015\u0001}A\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001c\u0001\u0005\u00029D\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0004!1Q\u0003\u0001C!\u00037Aq!a\f\u0001\t\u0013\t\t\u0004C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAu\u0001\u0011%\u00111\u001e\u0005\b\u0003s\u0004A\u0011IA~\u0011\u001d\u0011\u0019\u0002\u0001C!\u0005+\u0011\u0011#\u0012<f]R\u001cv.\u001e:dKJ{W\u000f^3t\u0015\t)b#\u0001\u0004s_V$Xm\u001d\u0006\u0003/a\tAA[7ba*\u0011\u0011DG\u0001\u0006U\u0006lWm\u001d\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\u0003\u0006\f\u001a\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t1qJ\u00196fGR\u0004\"!\u000b\u0016\u000e\u0003YI!a\u000b\f\u0003\u0015)k\u0015\t\u0015*pkR,7\u000f\u0005\u0002.a5\taF\u0003\u000201\u0005!1m\u001c:f\u0013\t\tdF\u0001\u0007ESN\u001cwN\u001c8fGR|'\u000f\u0005\u0002.g%\u0011AG\f\u0002\u001e\u0007>tg.Z2uS>tG)Z:de&\u0004H/[8o'V\u0004\b\u000f\\5fe\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003uY\tA\u0001\u001b;ua&\u0011A(\u000f\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005yQo]3s!J|g/[:j_:,'\u000f\u0005\u00029\u0001&\u0011\u0011)\u000f\u0002\u0011+N,'\u000f\u0015:pm&\u001c\u0018n\u001c8j]\u001e\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rb\ta!\u001a<f]R\u001c\u0018B\u0001%F\u0005!)e/\u001a8u\u0005V\u001c\b\u0006\u0002\u0003K%N\u0003\"a\u0013)\u000e\u00031S!!\u0014(\u0002\r%t'.Z2u\u0015\u0005y\u0015a\u00026bW\u0006\u0014H/Y\u0005\u0003#2\u0013QAT1nK\u0012\fQA^1mk\u0016\f\u0013\u0001V\u0001\u0005\u00156\u000b\u0005+\u0001\bqkND7+\u001a:jC2L'0\u001a:\u0011\u0005]SV\"\u0001-\u000b\u0005e3\u0012\u0001\u00026t_:L!a\u0017-\u0003\u001dA+8\u000f[*fe&\fG.\u001b>fe\u0006\u0001B/\u001f9f'R\fG/\u001a$bGR|'/\u001f\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\faa\u00195b]\u001e,'B\u00012\u0017\u0003\r\t\u0007/[\u0005\u0003I~\u0013\u0001\u0003V=qKN#\u0018\r^3GC\u000e$xN]=\u0002\u001f\u0011,G.Z4bi&|gn\u0015;pe\u0016\u0004\"aZ6\u000e\u0003!T!AY5\u000b\u0005)D\u0012\u0001B;tKJL!\u0001\u001c5\u0003\u001f\u0011+G.Z4bi&|gn\u0015;pe\u0016\fa\u0001P5oSRtDcB8rkZD\u0018P\u001f\t\u0003a\u0002i\u0011\u0001\u0006\u0005\u0006k!\u0001\ra\u000e\u0015\u0005c*\u00136/I\u0001u\u0003!\u0011fiQ\u00179mI\n\u0004\"\u0002 \t\u0001\u0004y\u0004\"\u0002\"\t\u0001\u0004\u0019\u0005\u0006\u0002<K%NCQ!\u0016\u0005A\u0002YCQ\u0001\u0018\u0005A\u0002uCQ!\u001a\u0005A\u0002\u0019D#\u0001\u0003?\u0011\u0005-k\u0018B\u0001@M\u0005\u0019IeN[3di\u0006q1m\u001c8oK\u000e$X\rZ+tKJ\u001cXCAA\u0002!!\t)!a\u0004\u0002\u0014\u0005MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\u000e\u0011\nA!\u001e;jY&!\u0011\u0011CA\u0004\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004a\u0006U\u0011bAA\f)\ti1\t\\5f]R\u001cuN\u001c;fqR\fqbY8o]\u0016\u001cG/\u001a3Vg\u0016\u00148\u000f\t\u000b\u0003\u0003;\u0001b!a\b\u0002&\u0005%RBAA\u0011\u0015\u0011\t\u0019#a\u0003\u0002\rM$(/Z1n\u0013\u0011\t9#!\t\u0003\rM#(/Z1n!\rI\u00131F\u0005\u0004\u0003[1\"!\u0003&N\u0003B\u0013v.\u001e;f\u0003%A\u0017M\u001c3mKN\u001bV\t\u0006\u0004\u00024\u0005-\u0013\u0011\r\t\u0007\u0003k\t\t%!\u0012\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007=\niD\u0003\u0002\u0002@\u00059!/Z1di>\u0014\u0018\u0002BA\"\u0003o\u0011A!T8o_B\u0019\u0011%a\u0012\n\u0007\u0005%#E\u0001\u0003W_&$\u0007bBA'\u0019\u0001\u0007\u0011qJ\u0001\be\u0016\fX/Z:u!\u0011\t\t&!\u0018\u000e\u0005\u0005M#\u0002BA+\u0003/\naa]3sm\u0016\u0014(b\u0001\u001e\u0002Z)!\u00111LA\u001f\u0003\u0015qW\r\u001e;z\u0013\u0011\ty&a\u0015\u0003#!#H\u000f]*feZ,'OU3rk\u0016\u001cH\u000fC\u0004\u0002d1\u0001\r!!\u001a\u0002\u0011I,7\u000f]8og\u0016\u0004B!!\u0015\u0002h%!\u0011\u0011NA*\u0005IAE\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\u0002\u0017I,w-[:uKJ\u001c6+\u0012\u000b\t\u0003_\n9)!#\u0002\u001aB1\u0011\u0011OA=\u0003{j!!a\u001d\u000b\t\u0005e\u0012Q\u000f\u0006\u0005\u0003o\nY$A\u0003tG\u0006d\u0017-\u0003\u0003\u0002|\u0005M$!B*N_:|\u0007\u0003BA@\u0003\u0007k!!!!\u000b\u0005\u0005]\u0014\u0002BAC\u0003\u0003\u0013A!\u00168ji\"9\u00111M\u0007A\u0002\u0005\u0015\u0004bBAF\u001b\u0001\u0007\u0011QR\u0001\bg\u0016\u001c8/[8o!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ1\u00059Q.Y5mE>D\u0018\u0002BAL\u0003#\u0013a\"T1jY\n|\u0007pU3tg&|g\u000eC\u0004\u0002\u001c6\u0001\r!!(\u0002\u000f=\u0004H/[8ogB\u0019\u0001/a(\n\u0007\u0005\u0005FC\u0001\nFm\u0016tGoU8ve\u000e,w\n\u001d;j_:\u001c\u0018AC1t'N+UI^3oiR!\u0011qUA_!\u0011\tI+a.\u000f\t\u0005-\u00161\u0017\t\u0005\u0003[\u000b\t)\u0004\u0002\u00020*\u0019\u0011\u0011\u0017\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0011\t),!!\u0002\rA\u0013X\rZ3g\u0013\u0011\tI,a/\u0003\rM#(/\u001b8h\u0015\u0011\t),!!\t\u000f\u0005}f\u00021\u0001\u0002B\u0006yq.\u001e;c_VtG-T3tg\u0006<W\r\u0005\u0003\u0002D\u0006\u001dWBAAc\u0015\tyc#\u0003\u0003\u0002J\u0006\u0015'aD(vi\n|WO\u001c3NKN\u001c\u0018mZ3\u0002E!\fg\u000e\u001a7f\u0007>tg.Z2uS>tWi\u001d;bE2L7\u000f[7f]R,%O]8s)\u0019\ty-!5\u0002hB1\u0011\u0011OA=\u0003\u000bBq!a5\u0010\u0001\u0004\t).A\u0005uQJ|w/\u00192mKB!\u0011q[Aq\u001d\u0011\tI.!8\u000f\t\u00055\u00161\\\u0005\u0003\u0003oJA!a8\u0002\u0002\u00069\u0001/Y2lC\u001e,\u0017\u0002BAr\u0003K\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\t\u0005}\u0017\u0011\u0011\u0005\b\u0003Gz\u0001\u0019AA3\u00039\u0011Xm\u001d9p]\u0012$U\r^1jYN$b!a4\u0002n\u0006=\bbBA2!\u0001\u0007\u0011Q\r\u0005\b\u0003c\u0004\u0002\u0019AAz\u0003\u001d!W\r^1jYN\u0004B!a1\u0002v&!\u0011q_Ac\u00059\u0001&o\u001c2mK6$U\r^1jYN\f!\u0002Z5tG>tg.Z2u)\u0011\ti(!@\t\u000f\u0005}\u0018\u00031\u0001\u0003\u0002\u0005AQo]3s]\u0006lW\r\u0005\u0004\u0003\u0004\t%!QB\u0007\u0003\u0005\u000bQAAa\u0002\u0002\f\u0005Aa-\u001e8di&|g.\u0003\u0003\u0003\f\t\u0015!!\u0003)sK\u0012L7-\u0019;f!\ri#qB\u0005\u0004\u0005#q#\u0001C+tKJt\u0017-\\3\u0002'\u0011,7o\u0019:jE\u0016\u001cuN\u001c8fGRLwN\\:\u0015\u0005\t]\u0001CBA\u0010\u0003K\u0011I\u0002E\u0002.\u00057I1A!\b/\u0005U\u0019uN\u001c8fGRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004")
public class EventSourceRoutes
implements JMAPRoutes,
Disconnector,
ConnectionDescriptionSupplier {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;
    private final DelegationStore delegationStore;
    private final ConcurrentHashMap<ClientContext, ClientContext> connectedUsers;

    public Authenticator authenticator() {
        return this.authenticator;
    }

    private ConcurrentHashMap<ClientContext, ClientContext> connectedUsers() {
        return this.connectedUsers;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/eventSource")).action((request, response) -> this.handleSSE(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/eventSource")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleSSE(HttpServerRequest request, HttpServerResponse response) {
        return ((SMono)new EventSourceOptionsFactory(this.typeStateFactory).forRequest(request).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)options -> SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.registerSSE(response, (MailboxSession)mailboxSession, (EventSourceOptions)options))))).onErrorResume((Function1 & Serializable)throwable -> this.handleConnectionEstablishmentError((Throwable)throwable, response)).asJava().then();
    }

    private SMono<BoxedUnit> registerSSE(HttpServerResponse response, MailboxSession session, EventSourceOptions options) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        this.connectedUsers().put(context, context);
        SFlux<PingMessage> qual$1 = options.pingPolicy().asFlux();
        Function1 & Serializable x$1 = (Function1 & Serializable)ping -> {
            EventSourceRoutes.$anonfun$registerSSE$1(context, ping);
            return BoxedUnit.UNIT;
        };
        Option x$2 = qual$1.subscribe$default$2();
        Option x$3 = qual$1.subscribe$default$3();
        Disposable pingDisposable = qual$1.subscribe((Function1)x$1, x$2, x$3);
        SMono$.MODULE$.just((Object)session.getUser()).concatWith((Publisher)SFlux$.MODULE$.fromPublisher(this.delegationStore.delegatedUsers(session.getUser()))).map((Function1 & Serializable)username -> AccountIdRegistrationKey$.MODULE$.of((Username)username)).collectSeq().flatMap((Function1 & Serializable)keys -> SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener(options.types(), context.outbound()), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)keys).asJavaCollection()))).doOnNext((Function1 & Serializable)newRegistration -> {
            context.withRegistration(newRegistration);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.boundedElastic()).subscribe();
        return SMono$.MODULE$.apply((Publisher)response.addHeader((CharSequence)"Connection", (CharSequence)"keep-alive").sse().sendString((Publisher)options.closeAfter().applyOn((SFlux<OutboundMessage>)SFlux$.MODULE$.apply((Publisher)sink.asFlux())).map((Function1 & Serializable)outboundMessage -> this.asSSEEvent((OutboundMessage)outboundMessage)), StandardCharsets.UTF_8).then().doFinally(x$5 -> context.clean()).doFinally(x$6 -> this.connectedUsers().remove(context)).doFinally(x$7 -> pingDisposable.dispose()).then()).then();
    }

    private String asSSEEvent(OutboundMessage outboundMessage) {
        String string2;
        OutboundMessage outboundMessage2 = outboundMessage;
        if (outboundMessage2 instanceof PingMessage) {
            string2 = "ping";
        } else if (outboundMessage2 instanceof StateChange) {
            string2 = "state";
        } else {
            throw new NotImplementedError();
        }
        String event = string2;
        return "event: " + event + "\ndata: " + Json$.MODULE$.stringify(this.pushSerializer.serializeSSE(outboundMessage)) + "\n\n";
    }

    private SMono<Void> handleConnectionEstablishmentError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse response, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)response.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    public void disconnect(Predicate<Username> username) {
        List<ClientContext> contexts = this.connectedUsers().values().stream().filter(context -> username.test(context.session().getUser())).toList();
        contexts.forEach(context -> {
            context.clean();
            this.connectedUsers().remove(context);
        });
    }

    public Stream<ConnectionDescription> describeConnections() {
        boolean writable = true;
        boolean encrypted = true;
        return this.connectedUsers().values().stream().map(context -> new ConnectionDescription("JMAP", "EventSource", Optional.empty(), Optional.empty(), context.pushRegistration().get() != null, context.pushRegistration().get() != null, writable, !encrypted, Optional.ofNullable(context.session().getUser()), (Map)ImmutableMap.of()));
    }

    public static final /* synthetic */ void $anonfun$registerSSE$1(ClientContext context$1, PingMessage ping) {
        context$1.outbound().emitNext((Object)ping, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    @Inject
    public EventSourceRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, PushSerializer pushSerializer, TypeStateFactory typeStateFactory, DelegationStore delegationStore) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
        this.delegationStore = delegationStore;
        this.connectedUsers = new ConcurrentHashMap();
    }
}

