/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.webadmin;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxFlagInconsistenciesService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxInconsistenciesService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesService;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.CassandraMappingsRoutes;
import org.apache.james.webadmin.routes.RecomputeMailboxCountersRequestToTask;
import org.apache.james.webadmin.routes.SolveMailboxInconsistenciesRequestToTask;
import org.apache.james.webadmin.routes.SolveMessageDeletedInconsistenciesRequestToTask;
import org.apache.james.webadmin.routes.SolveMessageInconsistenciesRequestToTask;
import org.apache.james.webadmin.routes.SolveMessageRecentInconsistenciesRequestToTask;
import org.apache.james.webadmin.service.CassandraMappingsService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;

public class InconsistencySolvingRoutesModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new SolveRRTInconsistenciesModules());
        this.install((Module)new SolveMailboxInconsistenciesModules());
        this.install((Module)new SolveMessageInconsistenciesModules());
        this.install((Module)new MailboxFlagInconsistencyModule());
    }

    public static class SolveRRTInconsistenciesModules
    extends AbstractModule {
        protected void configure() {
            this.bind(CassandraMappingsRoutes.class).in(Scopes.SINGLETON);
            this.bind(CassandraMappingsService.class).in(Scopes.SINGLETON);
            Multibinder routesMultibinder = Multibinder.newSetBinder((Binder)this.binder(), Routes.class);
            routesMultibinder.addBinding().to(CassandraMappingsRoutes.class);
        }
    }

    public static class SolveMailboxInconsistenciesModules
    extends AbstractModule {
        protected void configure() {
            this.bind(RecomputeMailboxCountersService.class).in(Scopes.SINGLETON);
            this.bind(SolveMailboxInconsistenciesService.class).in(Scopes.SINGLETON);
            Multibinder multiBinder = Multibinder.newSetBinder((Binder)this.binder(), TaskFromRequestRegistry.TaskRegistration.class, (Annotation)Names.named((String)"allMailboxesTasks"));
            multiBinder.addBinding().to(SolveMailboxInconsistenciesRequestToTask.class);
            multiBinder.addBinding().to(RecomputeMailboxCountersRequestToTask.class);
            multiBinder.addBinding().to(SolveMessageDeletedInconsistenciesRequestToTask.class);
            multiBinder.addBinding().to(SolveMessageRecentInconsistenciesRequestToTask.class);
        }
    }

    public static class SolveMessageInconsistenciesModules
    extends AbstractModule {
        protected void configure() {
            this.bind(SolveMessageInconsistenciesService.class).in(Scopes.SINGLETON);
            Multibinder multiBinder = Multibinder.newSetBinder((Binder)this.binder(), TaskFromRequestRegistry.TaskRegistration.class, (Annotation)Names.named((String)"allMessagesTasks"));
            multiBinder.addBinding().to(SolveMessageInconsistenciesRequestToTask.class);
        }
    }

    public static class MailboxFlagInconsistencyModule
    extends AbstractModule {
        public void configure() {
            Multibinder solveMailboxFlagInconsistenciesServiceMultibinder = Multibinder.newSetBinder((Binder)this.binder(), SolveMailboxFlagInconsistenciesService.SolveMessageFlagInconsistencyStrategy.class);
            solveMailboxFlagInconsistenciesServiceMultibinder.addBinding().to(SolveMailboxFlagInconsistenciesService.SolveMailboxDeletedFlagInconsistenciesStrategy.class);
            solveMailboxFlagInconsistenciesServiceMultibinder.addBinding().to(SolveMailboxFlagInconsistenciesService.SoleMailboxRecentFlagInconsistenciesStrategy.class);
        }

        @Provides
        @Singleton
        public SolveMailboxFlagInconsistenciesService.SolveMailboxDeletedFlagInconsistenciesStrategy provideSolveMailboxDeletedFlagInconsistenciesStrategy(CassandraDeletedMessageDAO dao) {
            return new SolveMailboxFlagInconsistenciesService.SolveMailboxDeletedFlagInconsistenciesStrategy(dao);
        }

        @Provides
        @Singleton
        public SolveMailboxFlagInconsistenciesService.SoleMailboxRecentFlagInconsistenciesStrategy provideSoleMailboxRecentFlagInconsistenciesStrategy(CassandraMailboxRecentsDAO dao) {
            return new SolveMailboxFlagInconsistenciesService.SoleMailboxRecentFlagInconsistenciesStrategy(dao);
        }
    }
}

