/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler.protocol;

import javax.mail.event.TransportAdapter;
import javax.mail.event.TransportEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronousTransportListener
extends TransportAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SynchronousTransportListener.class);
    private boolean finished = false;
    private final Object LOCK = new Object();

    public void messageDelivered(TransportEvent e) {
        logger.debug("Message delivered");
        this.finish();
    }

    public void messageNotDelivered(TransportEvent e) {
        logger.debug("Message not delivered");
        this.finish();
    }

    public void messagePartiallyDelivered(TransportEvent e) {
        logger.debug("Message partially delivered");
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attend() throws InterruptedException {
        Object object = this.LOCK;
        synchronized (object) {
            while (!this.finished) {
                this.LOCK.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.finished = true;
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notifyAll();
        }
    }
}

