/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleMetadata;

public class SampleBuilder {
    private static final DecimalFormat DEFAULT_FLOAT_FORMATTER = new DecimalFormat("#########0.00#");
    private final SampleMetadata metadata;
    private final String[] data;
    private final NumberFormat floatFormatter;
    private int k = 0;
    private long row = 0L;

    public SampleBuilder(SampleMetadata metadata, NumberFormat floatFormatter) {
        this.floatFormatter = floatFormatter == null ? DEFAULT_FLOAT_FORMATTER : floatFormatter;
        this.metadata = metadata;
        this.data = new String[metadata.getColumnCount()];
        this.k = 0;
        this.row = 0L;
    }

    public SampleBuilder(SampleMetadata metadata) {
        this(metadata, DEFAULT_FLOAT_FORMATTER);
    }

    public final SampleMetadata getMetadata() {
        return this.metadata;
    }

    public SampleBuilder add(String e) {
        if (this.k < this.data.length) {
            this.data[this.k++] = e;
        }
        return this;
    }

    public SampleBuilder add(long e) {
        this.add(Long.toString(e));
        return this;
    }

    public SampleBuilder add(double e) {
        this.add(this.floatFormatter.format(e));
        return this;
    }

    public Sample build() {
        while (this.k < this.data.length) {
            this.data[this.k++] = "";
        }
        String[] sampleData = new String[this.data.length];
        System.arraycopy(this.data, 0, sampleData, 0, this.data.length);
        Sample out = new Sample(this.row++, this.metadata, sampleData);
        this.k = 0;
        return out;
    }

    static {
        DEFAULT_FLOAT_FORMATTER.setRoundingMode(RoundingMode.HALF_DOWN);
        DEFAULT_FLOAT_FORMATTER.setGroupingUsed(false);
        DecimalFormatSymbols newSymbols = new DecimalFormatSymbols(Locale.getDefault());
        newSymbols.setDecimalSeparator('.');
        DEFAULT_FLOAT_FORMATTER.setDecimalFormatSymbols(newSymbols);
    }
}

