/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesDownloader.class);
    private static final long THREAD_KEEP_ALIVE_TIME = JMeterUtils.getPropDefault((String)"httpsampler.parallel_download_thread_keepalive_inseconds", (long)60L);
    private static final int MIN_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = Integer.MAX_VALUE;
    private static final ResourcesDownloader INSTANCE = new ResourcesDownloader();
    private ThreadPoolExecutor concurrentExecutor = null;

    public static ResourcesDownloader getInstance() {
        return INSTANCE;
    }

    private ResourcesDownloader() {
        this.init();
    }

    private void init() {
        LOG.info("Creating ResourcesDownloader with keepalive_inseconds : {}", (Object)THREAD_KEEP_ALIVE_TIME);
        this.concurrentExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, THREAD_KEEP_ALIVE_TIME, TimeUnit.SECONDS, new SynchronousQueue(), r -> {
            Thread t = new Thread(r);
            t.setName("ResDownload-" + t.getName());
            t.setDaemon(true);
            return t;
        }){};
    }

    public void shrink() {
        if (this.concurrentExecutor.getPoolSize() <= 1) {
            return;
        }
        this.concurrentExecutor.purge();
        ArrayList drainList = new ArrayList();
        this.concurrentExecutor.getQueue().drainTo(drainList);
        if (!drainList.isEmpty()) {
            LOG.warn("the pool executor workqueue is not empty size={}", (Object)drainList.size());
            for (Runnable runnable : drainList) {
                if (runnable instanceof Future) {
                    Future f = (Future)((Object)runnable);
                    f.cancel(true);
                    continue;
                }
                LOG.warn("Content of workqueue is not an instance of Future");
            }
        }
        this.concurrentExecutor.setMaximumPoolSize(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Future<AsynSamplerResultHolder>> invokeAllAndAwaitTermination(int maxConcurrentDownloads, List<Callable<AsynSamplerResultHolder>> list) throws InterruptedException {
        ArrayList<Future<AsynSamplerResultHolder>> submittedTasks = new ArrayList<Future<AsynSamplerResultHolder>>();
        if (list.isEmpty()) {
            return submittedTasks;
        }
        this.concurrentExecutor.setMaximumPoolSize(Integer.MAX_VALUE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PoolSize={} LargestPoolSize={}", (Object)this.concurrentExecutor.getPoolSize(), (Object)this.concurrentExecutor.getLargestPoolSize());
        }
        ExecutorCompletionService<AsynSamplerResultHolder> completionService = new ExecutorCompletionService<AsynSamplerResultHolder>(this.concurrentExecutor);
        int remainingTasksToTake = list.size();
        try {
            int i = 0;
            for (i = 0; i < Math.min(maxConcurrentDownloads, list.size()); ++i) {
                Callable<AsynSamplerResultHolder> callable = list.get(i);
                submittedTasks.add(completionService.submit(callable));
            }
            while (i < list.size()) {
                Callable<AsynSamplerResultHolder> callable = list.get(i);
                try {
                    completionService.take().get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Task execution failed", e.getCause());
                }
                --remainingTasksToTake;
                submittedTasks.add(completionService.submit(callable));
                ++i;
            }
            while (remainingTasksToTake > 0) {
                try {
                    completionService.take().get();
                }
                catch (ExecutionException executionException) {
                    throw new RuntimeException("Task execution failed", executionException.getCause());
                }
                --remainingTasksToTake;
            }
        }
        finally {
            if (remainingTasksToTake > 0) {
                LOG.debug("Interrupted while waiting for resource downloads : cancelling remaining tasks");
                for (Future future : submittedTasks) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
        }
        return submittedTasks;
    }

    public static class AsynSamplerResultHolder {
        private final HTTPSampleResult result;
        private final CollectionProperty cookies;

        public AsynSamplerResultHolder(HTTPSampleResult result, CollectionProperty cookies) {
            this.result = result;
            this.cookies = cookies;
        }

        public HTTPSampleResult getResult() {
            return this.result;
        }

        public CollectionProperty getCookies() {
            return this.cookies;
        }
    }
}

