/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.PointLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.PointRangeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.CompositeLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.VLineLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShapeSvg;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J.\u0010(\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010\u00170)2\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0006H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "fattenMidPoint", "", "getFattenMidPoint", "()D", "setFattenMidPoint", "(D)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "vector", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "fatten", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPointRangeGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1549#2:131\n1620#2,3:132\n1#3:135\n*S KotlinDebug\n*F\n+ 1 PointRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom\n*L\n43#1:131\n43#1:132,3\n*E\n"})
public final class PointRangeGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    private double fattenMidPoint;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    public static final boolean HANDLES_GROUPS = false;
    public static final double DEF_FATTEN = 5.0;

    public PointRangeGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.fattenMidPoint = 5.0;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
    }

    public final double getFattenMidPoint() {
        return this.fattenMidPoint;
    }

    public final void setFattenMidPoint(double d) {
        this.fattenMidPoint = d;
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    private final DoubleVector afterRotation(DoubleVector vector) {
        return this.flipHelper.flip(vector);
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        LegendKeyElementFactory[] legendKeyElementFactoryArray = new LegendKeyElementFactory[]{new VLineLegendKeyElementFactory(), new PointLegendKeyElementFactory(5.0)};
        return new CompositeLegendKeyElementFactory(legendKeyElementFactoryArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        GeomHelper.SvgElementHelper helper2 = geomHelper.createSvgElementHelper();
        helper2.setStrokeAlphaEnabled(true);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.POINT_RANGE, ctx);
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> yAes = this.afterRotation(Aes.Companion.getY());
        Aes<Double> minAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this.afterRotation(Aes.Companion.getYMAX());
        Iterable<DataPointAesthetics> dataPoints2 = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), xAes, yAes, minAes, maxAes);
        for (DataPointAesthetics p : dataPoints2) {
            DoubleVector location2;
            PointShape shape;
            Double d = p.get(xAes);
            Intrinsics.checkNotNull((Object)d);
            double x = ((Number)d).doubleValue();
            Double d2 = p.get(yAes);
            Intrinsics.checkNotNull((Object)d2);
            double y = ((Number)d2).doubleValue();
            Double d3 = p.get(minAes);
            Intrinsics.checkNotNull((Object)d3);
            double ymin = ((Number)d3).doubleValue();
            Double d4 = p.get(maxAes);
            Intrinsics.checkNotNull((Object)d4);
            double ymax = ((Number)d4).doubleValue();
            DoubleVector start2 = this.afterRotation(new DoubleVector(x, ymin));
            DoubleVector end = this.afterRotation(new DoubleVector(x, ymax));
            if (helper2.createLine(start2, end, p, (Function1<? super DataPointAesthetics, Double>)((Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).lineWidth(p0);
                }
            })) != null) {
                SvgLineElement it;
                boolean bl = false;
                root.add((SvgNode)it);
            }
            Intrinsics.checkNotNull((Object)geomHelper.toClient(this.afterRotation(new DoubleVector(x, y)), p));
            Intrinsics.checkNotNull((Object)p.shape());
            SvgSlimObject o = PointShapeSvg.INSTANCE.create(shape, location2, p, this.fattenMidPoint);
            root.add((SvgNode)GeomBase.Companion.wrap(o));
        }
        Object[] objectArray = new Aes[]{minAes, maxAes};
        FlippableGeomHelper.buildHints$default(this.flipHelper, CollectionsKt.listOf((Object[])objectArray), aesthetics2, pos, coord, ctx, this.clientRectByDataPoint(ctx, geomHelper, this.fattenMidPoint), buildIntern.3.INSTANCE, colorsByDataPoint, null, 256, null);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx, GeomHelper geomHelper, double fatten) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(this, geomHelper, fatten, ctx){
            final /* synthetic */ PointRangeGeom this$0;
            final /* synthetic */ GeomHelper $geomHelper;
            final /* synthetic */ double $fatten;
            final /* synthetic */ GeomContext $ctx;
            {
                this.this$0 = $receiver;
                this.$geomHelper = $geomHelper;
                this.$fatten = $fatten;
                this.$ctx = $ctx;
                super(1);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                DoubleRectangle doubleRectangle;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Aes xAes = PointRangeGeom.access$afterRotation(this.this$0, Aes.Companion.getX());
                Aes yAes = PointRangeGeom.access$afterRotation(this.this$0, Aes.Companion.getY());
                if (p.defined(xAes) && p.defined(yAes)) {
                    T t = p.get(xAes);
                    Intrinsics.checkNotNull(t);
                    double x = ((Number)t).doubleValue();
                    T t2 = p.get(yAes);
                    Intrinsics.checkNotNull(t2);
                    double y = ((Number)t2).doubleValue();
                    PointShape pointShape = p.shape();
                    Intrinsics.checkNotNull((Object)pointShape);
                    PointShape shape = pointShape;
                    DoubleRectangle doubleRectangle2 = this.$geomHelper.toClient(PointRangeGeom.access$afterRotation(this.this$0, new DoubleRectangle(new DoubleVector(x, y), DoubleVector.Companion.getZERO())), p);
                    Intrinsics.checkNotNull((Object)doubleRectangle2);
                    DoubleRectangle rect = doubleRectangle2;
                    double shapeSize = shape.size(p, this.$fatten);
                    double strokeWidth = shape.strokeWidth(p);
                    double width2 = shapeSize + strokeWidth;
                    boolean needToFlip = PointRangeGeom.access$isVertical$p(this.this$0) ? this.$ctx.getFlipped() : !this.$ctx.getFlipped();
                    doubleRectangle = GeomUtil.INSTANCE.extendWidth$plot_base(rect, width2, needToFlip);
                } else {
                    doubleRectangle = null;
                }
                return doubleRectangle;
            }
        };
    }

    public static final /* synthetic */ Aes access$afterRotation(PointRangeGeom $this, Aes aes2) {
        return $this.afterRotation(aes2);
    }

    public static final /* synthetic */ DoubleRectangle access$afterRotation(PointRangeGeom $this, DoubleRectangle rectangle) {
        return $this.afterRotation(rectangle);
    }

    public static final /* synthetic */ boolean access$isVertical$p(PointRangeGeom $this) {
        return $this.isVertical;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PointRangeGeom$Companion;", "", "()V", "DEF_FATTEN", "", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

