/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import org.apache.johnzon.jsonschema.generator.PojoGenerator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="jsonschema2pojo", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JsonSchemaToPojoMojo
extends AbstractMojo {
    @Parameter
    private PojoGenerator.PojoConfiguration generator;
    @Parameter(property="johnzon.jsonschema.extensions", defaultValue=".jsonschema.json")
    private List<String> jsonSchemaExtensions;
    @Parameter(property="johnzon.source", defaultValue="${project.basedir}/src/main/johnzon/jsonschema")
    private File source;
    @Parameter(property="johnzon.target", defaultValue="${project.build.directory}/generated-sources/johnzon-pojo")
    private File target;

    public void execute() {
        final JsonReaderFactory readerFactory = Json.createReaderFactory(Collections.emptyMap());
        if (this.source.isDirectory()) {
            try {
                Files.walkFileTree(this.source.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String name = file.getFileName().toString();
                        List matchingExt = JsonSchemaToPojoMojo.this.jsonSchemaExtensions.stream().filter(name::endsWith).sorted(Comparator.comparing(String::length).reversed()).collect(Collectors.toList());
                        if (matchingExt.size() >= 1) {
                            PojoGenerator.PojoConfiguration conf = JsonSchemaToPojoMojo.this.generator == null ? new PojoGenerator.PojoConfiguration() : JsonSchemaToPojoMojo.this.generator;
                            conf.setClassName(name.substring(0, name.length() - ((String)matchingExt.get(0)).length()));
                            JsonSchemaToPojoMojo.this.dump(new PojoGenerator(conf).visitSchema(JsonSchemaToPojoMojo.this.read(readerFactory, JsonSchemaToPojoMojo.this.source.toPath())).generate());
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.dump(new PojoGenerator(this.generator == null ? new PojoGenerator.PojoConfiguration() : this.generator).visitSchema(this.read(readerFactory, this.source.toPath())).generate());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject read(JsonReaderFactory readerFactory, Path path) {
        try (JsonReader reader = readerFactory.createReader((Reader)Files.newBufferedReader(path));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void dump(Map<String, String> generate) {
        Path root = this.target.toPath();
        try {
            for (Map.Entry<String, String> entry : generate.entrySet()) {
                Path out = root.resolve(entry.getKey());
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                Files.write(out, entry.getValue().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

