/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.service.guard.impl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.ProxyManager;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.service.guard.tools.ACLConfigurationParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuardProxyCatalog
implements ServiceListener {
    public static final String KARAF_SECURED_SERVICES_SYSPROP = "karaf.secured.services";
    public static final String SERVICE_GUARD_ROLES_PROPERTY = "org.apache.karaf.service.guard.roles";
    public static final String KARAF_SECURED_COMMAND_COMPULSORY_ROLES_PROPERTY = "karaf.secured.command.compulsory.roles";
    static final String PROXY_CREATOR_THREAD_NAME = "Secure OSGi Service Proxy Creator";
    static final String PROXY_SERVICE_KEY = "." + GuardProxyCatalog.class.getName();
    static final String SERVICE_ACL_PREFIX = "org.apache.karaf.service.acl.";
    static final String SERVICE_GUARD_KEY = "service.guard";
    static final Logger LOG = LoggerFactory.getLogger(GuardProxyCatalog.class);
    private static final Pattern JAVA_METHOD_NAME_PATTERN = Pattern.compile("[a-zA-Z_$][a-zA-Z0-9_$]*");
    private static final String ROLE_WILDCARD = "*";
    private final BundleContext myBundleContext;
    private final Map<String, Filter> filters = new ConcurrentHashMap<String, Filter>();
    final ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> configAdminTracker;
    final ServiceTracker<ProxyManager, ProxyManager> proxyManagerTracker;
    final ConcurrentMap<Long, ServiceRegistrationHolder> proxyMap = new ConcurrentHashMap<Long, ServiceRegistrationHolder>();
    final BlockingQueue<CreateProxyRunnable> createProxyQueue = new LinkedBlockingQueue<CreateProxyRunnable>();
    final String compulsoryRoles;
    volatile boolean runProxyCreator = true;
    volatile Thread proxyCreatorThread = null;

    GuardProxyCatalog(BundleContext bc) throws Exception {
        LOG.trace("Starting GuardProxyCatalog");
        this.myBundleContext = bc;
        this.compulsoryRoles = System.getProperty(KARAF_SECURED_COMMAND_COMPULSORY_ROLES_PROPERTY);
        if (this.compulsoryRoles == null) {
            LOG.info("No compulsory roles for a karaf command without the ACL as its system property is not set: {}", (Object)KARAF_SECURED_COMMAND_COMPULSORY_ROLES_PROPERTY);
        }
        bc.addServiceListener((ServiceListener)this);
        Filter caFilter = GuardProxyCatalog.getNonProxyFilter(bc, ConfigurationAdmin.class);
        LOG.trace("Creating Config Admin Tracker using filter {}", (Object)caFilter);
        this.configAdminTracker = new ServiceTracker(bc, caFilter, null);
        this.configAdminTracker.open();
        Filter pmFilter = GuardProxyCatalog.getNonProxyFilter(bc, ProxyManager.class);
        LOG.trace("Creating Proxy Manager Tracker using filter {}", (Object)pmFilter);
        this.proxyManagerTracker = new ServiceTracker(bc, pmFilter, (ServiceTrackerCustomizer)new ServiceProxyCreatorCustomizer());
        this.proxyManagerTracker.open();
    }

    static Filter getNonProxyFilter(BundleContext bc, Class<?> clazz) throws InvalidSyntaxException {
        Filter caFilter = bc.createFilter("(&(objectClass=" + clazz.getName() + ")(!(" + PROXY_SERVICE_KEY + "=*)))");
        return caFilter;
    }

    void close() {
        LOG.trace("Stopping GuardProxyCatalog");
        this.stopProxyCreator();
        this.proxyManagerTracker.close();
        this.configAdminTracker.close();
        this.myBundleContext.removeServiceListener((ServiceListener)this);
        for (ServiceRegistrationHolder holder : this.proxyMap.values()) {
            ServiceRegistration<?> reg = holder.registration;
            if (reg == null) continue;
            LOG.info("Unregistering proxy service of {} with properties {}", reg.getReference().getProperty("objectClass"), GuardProxyCatalog.copyProperties(reg.getReference()));
            reg.unregister();
        }
        this.proxyMap.clear();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sr = event.getServiceReference();
        if (event.getType() == 1) {
            return;
        }
        if (this.isProxy(sr)) {
            return;
        }
        Long orgServiceID = (Long)sr.getProperty("service.id");
        if (event.getType() == 4) {
            this.handleOriginalServiceUnregistering(orgServiceID);
        }
        if ((event.getType() & 0xA) > 0) {
            this.handleOriginalServiceModifed(orgServiceID, sr);
        }
    }

    private void handleOriginalServiceUnregistering(Long orgServiceID) {
        Iterator i = this.createProxyQueue.iterator();
        while (i.hasNext()) {
            CreateProxyRunnable cpr = (CreateProxyRunnable)i.next();
            if (!orgServiceID.equals(cpr.getOriginalServiceID())) continue;
            i.remove();
        }
        ServiceRegistrationHolder holder = (ServiceRegistrationHolder)this.proxyMap.remove(orgServiceID);
        if (holder != null && holder.registration != null) {
            holder.registration.unregister();
        }
    }

    private void handleOriginalServiceModifed(Long orgServiceID, ServiceReference<?> orgServiceRef) {
        ServiceRegistration<?> reg;
        ServiceRegistrationHolder holder = (ServiceRegistrationHolder)this.proxyMap.get(orgServiceID);
        if (holder != null && (reg = holder.registration) != null) {
            Object roles = reg.getReference().getProperty(SERVICE_GUARD_ROLES_PROPERTY);
            Dictionary<String, Object> newProxyProps = GuardProxyCatalog.proxyProperties(orgServiceRef);
            if (roles != null) {
                newProxyProps.put(SERVICE_GUARD_ROLES_PROPERTY, roles);
            } else {
                newProxyProps.remove(SERVICE_GUARD_ROLES_PROPERTY);
            }
            reg.setProperties(newProxyProps);
        }
    }

    boolean isProxy(ServiceReference<?> sr) {
        return sr.getProperty(PROXY_SERVICE_KEY) != null;
    }

    boolean handleProxificationForHook(ServiceReference<?> sr) {
        if (this.isProxy(sr)) {
            return false;
        }
        this.proxyIfNotAlreadyProxied(sr);
        return true;
    }

    void proxyIfNotAlreadyProxied(final ServiceReference<?> originalRef) {
        final long orgServiceID = (Long)originalRef.getProperty("service.id");
        final ServiceRegistrationHolder registrationHolder = new ServiceRegistrationHolder();
        ServiceRegistrationHolder previousHolder = this.proxyMap.putIfAbsent(orgServiceID, registrationHolder);
        if (previousHolder != null) {
            return;
        }
        LOG.trace("Will create proxy of service {}({})", originalRef.getProperty("objectClass"), (Object)orgServiceID);
        CreateProxyRunnable cpr = new CreateProxyRunnable(){

            @Override
            public long getOriginalServiceID() {
                return orgServiceID;
            }

            @Override
            public void run(ProxyManager pm) throws Exception {
                String[] objectClassProperty = (String[])originalRef.getProperty("objectClass");
                ProxyServiceFactory sf = new ProxyServiceFactory(pm, originalRef);
                registrationHolder.registration = originalRef.getBundle().getBundleContext().registerService(objectClassProperty, (Object)sf, this.proxyPropertiesRoles());
                Dictionary actualProxyProps = GuardProxyCatalog.copyProperties(registrationHolder.registration.getReference());
                LOG.debug("Created proxy of service {} under {} with properties {}", new Object[]{orgServiceID, actualProxyProps.get("objectClass"), actualProxyProps});
            }

            private Dictionary<String, Object> proxyPropertiesRoles() throws Exception {
                Dictionary p = GuardProxyCatalog.proxyProperties(originalRef);
                Set<String> roles = GuardProxyCatalog.this.getServiceInvocationRoles(originalRef);
                if (roles != null) {
                    roles.remove(GuardProxyCatalog.ROLE_WILDCARD);
                    p.put(GuardProxyCatalog.SERVICE_GUARD_ROLES_PROPERTY, roles);
                } else {
                    p.remove(GuardProxyCatalog.SERVICE_GUARD_ROLES_PROPERTY);
                }
                return p;
            }
        };
        try {
            this.createProxyQueue.put(cpr);
        }
        catch (InterruptedException e) {
            LOG.warn("Problem scheduling a proxy creator for service {}({})", new Object[]{originalRef.getProperty("objectClass"), orgServiceID, e});
            e.printStackTrace();
        }
    }

    private static Dictionary<String, Object> proxyProperties(ServiceReference<?> sr) {
        Dictionary<String, Object> p = GuardProxyCatalog.copyProperties(sr);
        p.put(PROXY_SERVICE_KEY, Boolean.TRUE);
        return p;
    }

    private static Dictionary<String, Object> copyProperties(ServiceReference<?> sr) {
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        for (String key : sr.getPropertyKeys()) {
            ((Dictionary)p).put(key, sr.getProperty(key));
        }
        return p;
    }

    Set<String> getServiceInvocationRoles(ServiceReference<?> serviceReference) throws Exception {
        boolean definitionFound = false;
        HashSet<String> allRoles = new HashSet<String>();
        for (Configuration config : this.getServiceGuardConfigs()) {
            Filter filter;
            Dictionary properties = config.getProperties();
            Object guardFilter = properties.get(SERVICE_GUARD_KEY);
            if (!(guardFilter instanceof String) || !(filter = this.getFilter((String)guardFilter)).match(serviceReference)) continue;
            definitionFound = true;
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                Object value;
                int idx2;
                int idx1;
                String key = (String)e.nextElement();
                String bareKey = key;
                int idx = bareKey.indexOf(40);
                if (idx >= 0) {
                    bareKey = bareKey.substring(0, idx);
                }
                if ((idx1 = bareKey.indexOf(91)) >= 0) {
                    bareKey = bareKey.substring(0, idx1);
                }
                if ((idx2 = bareKey.indexOf(42)) >= 0) {
                    bareKey = bareKey.substring(0, idx2);
                }
                if (!this.isValidMethodName(bareKey) || !((value = properties.get(key)) instanceof String)) continue;
                allRoles.addAll(ACLConfigurationParser.parseRoles((String)value));
            }
        }
        return definitionFound ? allRoles : null;
    }

    private Filter getFilter(String string) throws InvalidSyntaxException {
        Filter filter = this.filters.get(string);
        if (filter == null) {
            filter = this.myBundleContext.createFilter(string);
            this.filters.put(string, filter);
        }
        return filter;
    }

    private Configuration[] getServiceGuardConfigs() throws IOException, InvalidSyntaxException {
        ConfigurationAdmin ca = null;
        try {
            ca = (ConfigurationAdmin)this.configAdminTracker.waitForService(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (ca == null) {
            throw new IllegalStateException("Role based access for services requires the OSGi Configuration Admin Service to be present");
        }
        Configuration[] configs = ca.listConfigurations("(&(service.pid=org.apache.karaf.service.acl.*)(service.guard=*))");
        if (configs == null) {
            return new Configuration[0];
        }
        return configs;
    }

    private boolean isValidMethodName(String name) {
        return JAVA_METHOD_NAME_PATTERN.matcher(name).matches();
    }

    void stopProxyCreator() {
        this.runProxyCreator = false;
        if (this.proxyCreatorThread != null) {
            this.proxyCreatorThread.interrupt();
        }
    }

    static boolean currentUserHasRole(String reqRole) {
        String role;
        String clazz;
        if (ROLE_WILDCARD.equals(reqRole)) {
            return true;
        }
        int idx = reqRole.indexOf(58);
        if (idx > 0) {
            clazz = reqRole.substring(0, idx);
            role = reqRole.substring(idx + 1);
        } else {
            clazz = RolePrincipal.class.getName();
            role = reqRole;
        }
        AccessControlContext acc = AccessController.getContext();
        if (acc == null) {
            return false;
        }
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!clazz.equals(p.getClass().getName()) || !role.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    static interface CreateProxyRunnable {
        public long getOriginalServiceID();

        public void run(ProxyManager var1) throws Exception;
    }

    class ServiceProxyCreatorCustomizer
    implements ServiceTrackerCustomizer<ProxyManager, ProxyManager> {
        ServiceProxyCreatorCustomizer() {
        }

        public ProxyManager addingService(ServiceReference<ProxyManager> reference) {
            GuardProxyCatalog.this.runProxyCreator = true;
            ProxyManager svc = (ProxyManager)GuardProxyCatalog.this.myBundleContext.getService(reference);
            if (GuardProxyCatalog.this.proxyCreatorThread == null && svc != null) {
                GuardProxyCatalog.this.proxyCreatorThread = this.newProxyProducingThread(svc);
            }
            return svc;
        }

        private Thread newProxyProducingThread(final ProxyManager proxyManager) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (GuardProxyCatalog.this.runProxyCreator) {
                        CreateProxyRunnable proxyCreator = null;
                        try {
                            proxyCreator = GuardProxyCatalog.this.createProxyQueue.take();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        if (proxyCreator == null) continue;
                        try {
                            proxyCreator.run(proxyManager);
                        }
                        catch (Exception e) {
                            LOG.warn("Problem creating secured service proxy", (Throwable)e);
                        }
                    }
                    GuardProxyCatalog.this.proxyCreatorThread = null;
                }
            });
            t.setName(GuardProxyCatalog.PROXY_CREATOR_THREAD_NAME);
            t.setDaemon(true);
            t.start();
            return t;
        }

        public void modifiedService(ServiceReference<ProxyManager> reference, ProxyManager service) {
        }

        public void removedService(ServiceReference<ProxyManager> reference, ProxyManager service) {
            GuardProxyCatalog.this.stopProxyCreator();
        }
    }

    class ProxyInvocationListener
    implements InvocationListener {
        private final ServiceReference<?> serviceReference;

        ProxyInvocationListener(ServiceReference<?> sr) {
            this.serviceReference = sr;
        }

        public Object preInvoke(Object proxy, Method m, Object[] args) throws Throwable {
            String[] sig = new String[m.getParameterTypes().length];
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                sig[i] = m.getParameterTypes()[i].getName();
            }
            TreeMap<ACLConfigurationParser.Specificity, List<String>> roleMappings = new TreeMap<ACLConfigurationParser.Specificity, List<String>>();
            boolean foundMatchingConfig = false;
            Object guardFilter = null;
            for (Configuration config : GuardProxyCatalog.this.getServiceGuardConfigs()) {
                Filter filter;
                guardFilter = config.getProperties().get(GuardProxyCatalog.SERVICE_GUARD_KEY);
                if (!(guardFilter instanceof String) || !(filter = GuardProxyCatalog.this.myBundleContext.createFilter((String)guardFilter)).match(this.serviceReference)) continue;
                foundMatchingConfig = true;
                ArrayList<String> roles = new ArrayList<String>();
                ACLConfigurationParser.Specificity s = ACLConfigurationParser.getRolesForInvocation(m.getName(), args, sig, config.getProperties(), roles);
                if (s == ACLConfigurationParser.Specificity.NO_MATCH) continue;
                roleMappings.put(s, roles);
                if (s == ACLConfigurationParser.Specificity.ARGUMENT_MATCH) break;
            }
            if (!foundMatchingConfig) {
                if (GuardProxyCatalog.this.compulsoryRoles != null && guardFilter instanceof String && ((String)guardFilter).indexOf("osgi.command.scope") > 0 && ((String)guardFilter).indexOf("osgi.command.functio") > 0) {
                    roleMappings.put(ACLConfigurationParser.Specificity.NAME_MATCH, ACLConfigurationParser.parseRoles(GuardProxyCatalog.this.compulsoryRoles));
                } else {
                    return null;
                }
            }
            if (roleMappings.size() == 0) {
                LOG.info("Service {} has role mapping, but assigned no roles to method {}", this.serviceReference, (Object)m);
                throw new SecurityException("Insufficient credentials.");
            }
            List allowedRoles = (List)roleMappings.values().iterator().next();
            for (String role : allowedRoles) {
                if (!GuardProxyCatalog.currentUserHasRole(role)) continue;
                LOG.trace("Allow user with role {} to invoke service {} method {}", new Object[]{role, this.serviceReference, m});
                return null;
            }
            LOG.info("Current user does not have required roles ({}) for service {} method {} and/or arguments", new Object[]{allowedRoles, this.serviceReference, m});
            throw new SecurityException("Insufficient credentials.");
        }

        public void postInvokeExceptionalReturn(Object token, Object proxy, Method m, Throwable exception) throws Throwable {
        }

        public void postInvoke(Object token, Object proxy, Method m, Object returnValue) throws Throwable {
        }
    }

    class ProxyServiceFactory
    implements ServiceFactory<Object> {
        private final ProxyManager pm;
        private final ServiceReference<?> originalRef;

        ProxyServiceFactory(ProxyManager pm, ServiceReference<?> originalRef) {
            this.pm = pm;
            this.originalRef = originalRef;
        }

        public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
            HashSet allClasses = new HashSet();
            Object svc = bundle.getBundleContext().getService(this.originalRef);
            Class<?> curClass = svc.getClass();
            while (!Object.class.equals(curClass)) {
                allClasses.add(curClass);
                allClasses.addAll(Arrays.asList(curClass.getInterfaces()));
                curClass = curClass.getSuperclass();
            }
            Iterator i = allClasses.iterator();
            block3: while (i.hasNext()) {
                Class cls = (Class)i.next();
                if ((cls.getModifiers() & 5) == 0 || (cls.getModifiers() & 0x10) > 0 || cls.isAnonymousClass() || cls.isLocalClass()) {
                    i.remove();
                    continue;
                }
                for (Method m : cls.getDeclaredMethods()) {
                    if ((m.getModifiers() & 0x10) <= 0) continue;
                    i.remove();
                    continue block3;
                }
            }
            ProxyInvocationListener il = new ProxyInvocationListener(this.originalRef);
            try {
                return this.pm.createInterceptingProxy(this.originalRef.getBundle(), allClasses, svc, (InvocationListener)il);
            }
            catch (UnableToProxyException e) {
                throw new RuntimeException(e);
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
            bundle.getBundleContext().ungetService(this.originalRef);
        }
    }

    static class ServiceRegistrationHolder {
        volatile ServiceRegistration<?> registration;

        ServiceRegistrationHolder() {
        }
    }
}

