/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.future.CloseFuture;

public class ChannelSession
extends AbstractClientChannel {
    private Thread streamPumper;

    public ChannelSession() {
        super("session");
    }

    protected void doOpen() throws IOException {
        if (this.streaming == ClientChannel.Streaming.Async) {
            this.asyncIn = new ChannelAsyncOutputStream(this, 94){

                protected CloseFuture doCloseGracefully() {
                    try {
                        ChannelSession.this.sendEof();
                    }
                    catch (IOException e) {
                        ChannelSession.this.session.exceptionCaught(e);
                    }
                    return super.doCloseGracefully();
                }
            };
            this.asyncOut = new ChannelAsyncInputStream(this);
            this.asyncErr = new ChannelAsyncInputStream(this);
        } else {
            ChannelPipedOutputStream pos;
            ChannelPipedInputStream pis;
            this.invertedIn = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
            if (this.out == null) {
                pis = new ChannelPipedInputStream(this.localWindow);
                pos = new ChannelPipedOutputStream(pis);
                this.out = pos;
                this.invertedOut = pis;
            }
            if (this.err == null) {
                pis = new ChannelPipedInputStream(this.localWindow);
                pos = new ChannelPipedOutputStream(pis);
                this.err = pos;
                this.invertedErr = pis;
            }
            if (this.in != null) {
                this.streamPumper = new Thread("ClientInputStreamPump"){

                    public void run() {
                        ChannelSession.this.pumpInputStream();
                    }
                };
                this.streamPumper.setDaemon(true);
                this.streamPumper.start();
            }
        }
    }

    protected void doCloseImmediately() {
        if (this.streamPumper != null) {
            this.streamPumper.interrupt();
            this.streamPumper = null;
        }
        super.doCloseImmediately();
    }

    protected void pumpInputStream() {
        block4: {
            try {
                byte[] buffer = new byte[this.remoteWindow.getPacketSize()];
                while (!this.closeFuture.isClosed()) {
                    int len = this.securedRead(this.in, buffer, 0, buffer.length);
                    this.session.resetIdleTimeout();
                    if (len > 0) {
                        this.invertedIn.write(buffer, 0, len);
                        this.invertedIn.flush();
                        continue;
                    }
                    this.sendEof();
                    break;
                }
            }
            catch (Exception e) {
                if (this.isClosing()) break block4;
                this.log.info("Caught exception", (Throwable)e);
                this.close(false);
            }
        }
    }

    protected int securedRead(InputStream in, byte[] buf, int off, int len) throws IOException {
        int n = 0;
        do {
            int nread;
            if ((nread = in.read(buf, off + n, Math.min(1024, len - n))) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while (in.available() > 0);
        return n;
    }
}

