/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.util.Map;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="log", name="get", description="Shows the currently set log level.")
@Service
public class GetLogLevel
implements Action {
    @Argument(index=0, name="logger", description="The name of the logger, ALL or ROOT (default)", required=false, multiValued=false)
    String logger;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Reference
    LogService logService;

    public Object execute() throws Exception {
        Map<String, String> loggers = this.logService.getLevel(this.logger);
        ShellTable table = new ShellTable();
        table.column("Logger");
        table.column("Level");
        for (String logger : loggers.keySet()) {
            table.addRow().addContent(new Object[]{logger, loggers.get(logger)});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }
}

