/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.framework.util.Mutex;
import org.apache.felix.framework.util.SecureAction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakZipFileFactory {
    private static final int WEAKLY_CLOSED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private static final SecureAction m_secureAction = new SecureAction();
    private final List<WeakZipFile> m_zipFiles = new ArrayList<WeakZipFile>();
    private final List<WeakZipFile> m_openFiles = new ArrayList<WeakZipFile>();
    private final Mutex m_globalMutex = new Mutex();
    private final int m_limit;

    public WeakZipFileFactory(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be non-negative.");
        }
        this.m_limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeakZipFile create(File file) throws IOException {
        WeakZipFile wzf = new WeakZipFile(file);
        if (this.m_limit > 0) {
            try {
                this.m_globalMutex.down();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while acquiring global zip file mutex.");
            }
            try {
                this.m_zipFiles.add(wzf);
                this.m_openFiles.add(wzf);
                if (this.m_openFiles.size() > this.m_limit) {
                    WeakZipFile candidate = this.m_openFiles.get(0);
                    for (WeakZipFile tmp : this.m_openFiles) {
                        if (candidate.m_timestamp <= tmp.m_timestamp) continue;
                        candidate = tmp;
                    }
                    candidate._closeWeakly();
                }
            }
            finally {
                this.m_globalMutex.up();
            }
        }
        return wzf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<WeakZipFile> getZipZiles() {
        try {
            this.m_globalMutex.down();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Collections.EMPTY_LIST;
        }
        try {
            List<WeakZipFile> list = this.m_zipFiles;
            return list;
        }
        finally {
            this.m_globalMutex.up();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<WeakZipFile> getOpenZipZiles() {
        try {
            this.m_globalMutex.down();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Collections.EMPTY_LIST;
        }
        try {
            List<WeakZipFile> list = this.m_openFiles;
            return list;
        }
        finally {
            this.m_globalMutex.up();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WeakZipFile {
        private final File m_file;
        private final Mutex m_localMutex = new Mutex();
        private ZipFile m_zipFile;
        private int m_status = 1;
        private long m_timestamp;

        private WeakZipFile(File file) throws IOException {
            this.m_file = file;
            this.m_zipFile = m_secureAction.openZipFile(this.m_file);
            this.m_timestamp = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZipEntry getEntry(String name) {
            this.ensureZipFileIsOpen();
            try {
                ZipEntry dirEntry;
                ZipEntry ze = null;
                ze = this.m_zipFile.getEntry(name);
                if (ze != null && ze.getSize() == 0L && !ze.isDirectory() && (dirEntry = this.m_zipFile.getEntry(new StringBuffer().append(name).append('/').toString())) != null) {
                    ze = dirEntry;
                }
                ZipEntry zipEntry = ze;
                return zipEntry;
            }
            finally {
                this.m_localMutex.up();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration<ZipEntry> entries() {
            this.ensureZipFileIsOpen();
            try {
                Enumeration<? extends ZipEntry> e = this.m_zipFile.entries();
                ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
                while (e.hasMoreElements()) {
                    entries.add(e.nextElement());
                }
                Enumeration<ZipEntry> enumeration = Collections.enumeration(entries);
                return enumeration;
            }
            finally {
                this.m_localMutex.up();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream(ZipEntry ze) throws IOException {
            this.ensureZipFileIsOpen();
            try {
                InputStream is = this.m_zipFile.getInputStream(ze);
                WeakZipInputStream weakZipInputStream = new WeakZipInputStream(ze.getName(), is);
                return weakZipInputStream;
            }
            finally {
                this.m_localMutex.up();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeWeakly() {
            try {
                WeakZipFileFactory.this.m_globalMutex.down();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while acquiring global zip file mutex.");
            }
            try {
                this._closeWeakly();
            }
            finally {
                WeakZipFileFactory.this.m_globalMutex.up();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _closeWeakly() {
            try {
                this.m_localMutex.down();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
            }
            try {
                if (this.m_status == 1) {
                    try {
                        this.m_status = 0;
                        if (this.m_zipFile != null) {
                            this.m_zipFile.close();
                            this.m_zipFile = null;
                        }
                        WeakZipFileFactory.this.m_openFiles.remove(this);
                    }
                    catch (IOException ex) {
                        this.__close();
                    }
                }
            }
            finally {
                this.m_localMutex.up();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (WeakZipFileFactory.this.m_limit > 0) {
                try {
                    WeakZipFileFactory.this.m_globalMutex.down();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring global zip file mutex.");
                }
                try {
                    this.m_localMutex.down();
                }
                catch (InterruptedException ex) {
                    WeakZipFileFactory.this.m_globalMutex.up();
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
                }
            }
            try {
                ZipFile tmp = this.m_zipFile;
                this.__close();
                if (tmp != null) {
                    tmp.close();
                }
            }
            finally {
                this.m_localMutex.up();
                WeakZipFileFactory.this.m_globalMutex.up();
            }
        }

        private void __close() {
            this.m_status = 2;
            this.m_zipFile = null;
            WeakZipFileFactory.this.m_zipFiles.remove(this);
            WeakZipFileFactory.this.m_openFiles.remove(this);
        }

        private void ensureZipFileIsOpen() {
            if (WeakZipFileFactory.this.m_limit == 0) {
                return;
            }
            try {
                this.m_localMutex.down();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
            }
            if (this.m_status == 2) {
                this.m_localMutex.up();
                throw new IllegalStateException(new StringBuffer().append("Zip file is closed: ").append(this.m_file).toString());
            }
            IOException cause = null;
            if (this.m_status == 0) {
                this.m_localMutex.up();
                try {
                    WeakZipFileFactory.this.m_globalMutex.down();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring global zip file mutex.");
                }
                try {
                    this.m_localMutex.down();
                }
                catch (InterruptedException ex) {
                    WeakZipFileFactory.this.m_globalMutex.up();
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while acquiring local zip file mutex.");
                }
                if (this.m_status == 2) {
                    this.m_localMutex.up();
                    WeakZipFileFactory.this.m_globalMutex.up();
                    throw new IllegalStateException(new StringBuffer().append("Zip file is closed: ").append(this.m_file).toString());
                }
                if (this.m_status == 0) {
                    try {
                        this.__reopenZipFile();
                    }
                    catch (IOException ex) {
                        cause = ex;
                    }
                }
                WeakZipFileFactory.this.m_globalMutex.up();
            }
            if (this.m_zipFile == null) {
                this.m_localMutex.up();
                IllegalStateException ise = new IllegalStateException(new StringBuffer().append("Zip file is closed: ").append(this.m_file).toString());
                if (cause != null) {
                    ise.initCause(cause);
                }
                throw ise;
            }
        }

        private void __reopenZipFile() throws IOException {
            if (this.m_status == 0) {
                try {
                    this.m_zipFile = m_secureAction.openZipFile(this.m_file);
                    this.m_status = 1;
                    this.m_timestamp = System.currentTimeMillis();
                }
                catch (IOException ex) {
                    this.__close();
                    throw ex;
                }
                if (this.m_zipFile != null) {
                    WeakZipFileFactory.this.m_openFiles.add(this);
                    if (WeakZipFileFactory.this.m_openFiles.size() > WeakZipFileFactory.this.m_limit) {
                        WeakZipFile candidate = (WeakZipFile)WeakZipFileFactory.this.m_openFiles.get(0);
                        for (WeakZipFile tmp : WeakZipFileFactory.this.m_openFiles) {
                            if (candidate.m_timestamp <= tmp.m_timestamp) continue;
                            candidate = tmp;
                        }
                        candidate._closeWeakly();
                    }
                }
            }
        }

        class WeakZipInputStream
        extends InputStream {
            private final String m_entryName;
            private InputStream m_is;
            private int m_currentPos = 0;
            private ZipFile m_zipFileSnapshot;

            WeakZipInputStream(String entryName, InputStream is) {
                this.m_entryName = entryName;
                this.m_is = is;
                this.m_zipFileSnapshot = WeakZipFile.this.m_zipFile;
            }

            private void ensureInputStreamIsValid() throws IOException {
                if (WeakZipFileFactory.this.m_limit == 0) {
                    return;
                }
                WeakZipFile.this.ensureZipFileIsOpen();
                if (this.m_zipFileSnapshot != WeakZipFile.this.m_zipFile) {
                    this.m_zipFileSnapshot = WeakZipFile.this.m_zipFile;
                    if (this.m_is != null) {
                        try {
                            this.m_is.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        this.m_is = WeakZipFile.this.m_zipFile.getInputStream(WeakZipFile.this.m_zipFile.getEntry(this.m_entryName));
                        this.m_is.skip(this.m_currentPos);
                    }
                    catch (IOException ex) {
                        WeakZipFile.this.m_localMutex.up();
                        throw ex;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int available() throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int n = this.m_is.available();
                    return n;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    InputStream is = this.m_is;
                    this.m_is = null;
                    if (is != null) {
                        is.close();
                    }
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            public void mark(int i) {
            }

            public boolean markSupported() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read() throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int len = this.m_is.read();
                    if (len > 0) {
                        ++this.m_currentPos;
                    }
                    int n = len;
                    return n;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] bytes) throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int len = this.m_is.read(bytes);
                    if (len > 0) {
                        this.m_currentPos += len;
                    }
                    int n = len;
                    return n;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] bytes, int i, int i1) throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    int len = this.m_is.read(bytes, i, i1);
                    if (len > 0) {
                        this.m_currentPos += len;
                    }
                    int n = len;
                    return n;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }

            public void reset() throws IOException {
                throw new IOException("Unsupported operation");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long skip(long l) throws IOException {
                this.ensureInputStreamIsValid();
                try {
                    long len = this.m_is.skip(l);
                    if (len > 0L) {
                        this.m_currentPos = (int)((long)this.m_currentPos + len);
                    }
                    long l2 = len;
                    return l2;
                }
                finally {
                    WeakZipFile.this.m_localMutex.up();
                }
            }
        }
    }
}

