/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.jobhistory.cache.impl;

import org.apache.linkis.jobhistory.cache.QueryCacheManager;

import org.springframework.scheduling.quartz.QuartzJobBean;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledCleanJob extends QuartzJobBean {

  private static Logger logger = LoggerFactory.getLogger(ScheduledCleanJob.class);

  @Override
  protected void executeInternal(JobExecutionContext jobExecutionContext)
      throws JobExecutionException {
    logger.info("Started cache cleaning job.");
    QueryCacheManager queryCacheManager =
        (QueryCacheManager)
            jobExecutionContext
                .getJobDetail()
                .getJobDataMap()
                .get(QueryCacheManager.class.getName());
    queryCacheManager.cleanAll();
    logger.info("Finished cache cleaning job.");
  }
}
