/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LevelIconFactory;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.receivers.NewReceiverDialogPanel;
import org.apache.log4j.chainsaw.receivers.PluginPropertyEditorPanel;
import org.apache.log4j.chainsaw.receivers.ReceiverTreeCellRenderer;
import org.apache.log4j.chainsaw.receivers.ReceiversHelper;
import org.apache.log4j.chainsaw.receivers.ReceiversTreeModel;
import org.apache.log4j.chainsaw.receivers.VisualReceiver;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;

public class ReceiversPanel
extends JPanel
implements SettingsListener {
    final Action newReceiverButtonAction;
    final Action pauseReceiverButtonAction;
    final Action playReceiverButtonAction;
    final Action shutdownReceiverButtonAction;
    final Action saveReceiversButtonAction;
    final Action restartReceiverButtonAction;
    private final Action showReceiverHelpAction;
    private final Action startAllAction;
    private final JPopupMenu popupMenu = new ReceiverPopupMenu();
    private final JTree receiversTree = new JTree();
    private final NewReceiverPopupMenu newReceiverPopup = new NewReceiverPopupMenu();
    private final ReceiverToolbar buttonPanel;
    private final JSplitPane splitter = new JSplitPane();
    private final PluginPropertyEditorPanel pluginEditorPanel = new PluginPropertyEditorPanel();
    private final Logger logger = LogManager.getLogger(ReceiversPanel.class);
    private final PluginRegistry pluginRegistry;

    public ReceiversPanel() {
        super(new BorderLayout());
        LoggerRepository repo = LogManager.getLoggerRepository();
        final ReceiversTreeModel model = new ReceiversTreeModel();
        if (repo instanceof LoggerRepositoryEx) {
            this.pluginRegistry = ((LoggerRepositoryEx)repo).getPluginRegistry();
            this.pluginRegistry.addPluginListener(model);
            List c = this.pluginRegistry.getPlugins(VisualReceiver.class);
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                ((VisualReceiver)iter.next()).setContainer(this);
            }
            this.pluginRegistry.addPluginListener(new PluginListener(){

                @Override
                public void pluginStarted(PluginEvent e) {
                    if (e.getPlugin() instanceof VisualReceiver) {
                        ((VisualReceiver)((Object)e.getPlugin())).setContainer(ReceiversPanel.this);
                    }
                }

                @Override
                public void pluginStopped(PluginEvent e) {
                }
            });
        } else {
            this.pluginRegistry = null;
        }
        this.receiversTree.setModel(model);
        this.receiversTree.setExpandsSelectedPaths(true);
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                this.expandRoot();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.expandRoot();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.expandRoot();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.expandRoot();
            }

            private void expandRoot() {
                ReceiversPanel.this.receiversTree.expandPath(new TreePath(model.getPathToRoot(model.RootNode)));
            }
        });
        this.receiversTree.expandPath(new TreePath(model.getPathToRoot(model.RootNode)));
        this.receiversTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (event.getPath().getLastPathComponent() == model.RootNode) {
                    throw new ExpandVetoException(event);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.receiversTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node != null && node.getUserObject() != null && node.getUserObject() instanceof Plugin) {
                        Plugin p = (Plugin)node.getUserObject();
                        ReceiversPanel.this.logger.debug("plugin=" + p);
                        ReceiversPanel.this.pluginEditorPanel.setPlugin(p);
                    } else {
                        ReceiversPanel.this.pluginEditorPanel.setPlugin(null);
                    }
                }
            }
        });
        this.receiversTree.setToolTipText("Allows you to manage Log4j Receivers");
        this.newReceiverButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.newReceiverPopup.show(((ReceiversPanel)ReceiversPanel.this).buttonPanel.newReceiverButton, 0, ((ReceiversPanel)ReceiversPanel.this).buttonPanel.newReceiverButton.getHeight());
            }
        };
        this.newReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_NEW_RECEIVER));
        this.newReceiverButtonAction.putValue("ShortDescription", "Creates and configures a new Receiver");
        this.newReceiverButtonAction.putValue("Name", "New Receiver");
        this.newReceiverButtonAction.putValue("MnemonicKey", new Integer(78));
        this.newReceiverButtonAction.setEnabled(true);
        this.playReceiverButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.playCurrentlySelectedReceiver();
            }
        };
        this.playReceiverButtonAction.putValue("ShortDescription", "Resumes the selected Node");
        this.playReceiverButtonAction.putValue("Name", "Resume");
        this.playReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_RESUME_RECEIVER));
        this.playReceiverButtonAction.setEnabled(false);
        this.playReceiverButtonAction.putValue("MnemonicKey", new Integer(82));
        this.pauseReceiverButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.pauseCurrentlySelectedReceiver();
            }
        };
        this.pauseReceiverButtonAction.putValue("ShortDescription", "Pause the selected Receiver.  All events received will be discarded.");
        this.pauseReceiverButtonAction.putValue("Name", "Pause");
        this.pauseReceiverButtonAction.putValue("MnemonicKey", new Integer(80));
        this.pauseReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        this.pauseReceiverButtonAction.setEnabled(false);
        this.shutdownReceiverButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.shutdownCurrentlySelectedReceiver();
            }
        };
        this.shutdownReceiverButtonAction.putValue("ShortDescription", "Shuts down the selected Receiver, and removes it from the Plugin registry");
        this.shutdownReceiverButtonAction.putValue("Name", "Shutdown");
        this.shutdownReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_STOP_RECEIVER));
        this.shutdownReceiverButtonAction.putValue("MnemonicKey", new Integer(83));
        this.shutdownReceiverButtonAction.setEnabled(false);
        this.saveReceiversButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.saveReceivers();
            }
        };
        this.saveReceiversButtonAction.putValue("ShortDescription", "Save the current receiver configuration");
        this.saveReceiversButtonAction.putValue("Name", "Save receivers");
        this.saveReceiversButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.FILE_SAVE_AS));
        this.saveReceiversButtonAction.putValue("MnemonicKey", new Integer(86));
        this.restartReceiverButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Receiver selectedReceiver = ReceiversPanel.this.getCurrentlySelectedReceiver();
                if (selectedReceiver == null) {
                    return;
                }
                selectedReceiver.shutdown();
                selectedReceiver.activateOptions();
                if (selectedReceiver instanceof VisualReceiver) {
                    ((VisualReceiver)((Object)selectedReceiver)).setContainer(ReceiversPanel.this);
                }
            }
        };
        this.restartReceiverButtonAction.putValue("ShortDescription", "Restarts the selected Receiver");
        this.restartReceiverButtonAction.putValue("Name", "Restart");
        this.restartReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_RESTART));
        this.restartReceiverButtonAction.putValue("MnemonicKey", new Integer(82));
        this.restartReceiverButtonAction.setEnabled(false);
        this.showReceiverHelpAction = new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Receiver receiver = ReceiversPanel.this.getCurrentlySelectedReceiver();
                if (receiver != null) {
                    HelpManager.getInstance().showHelpForClass(receiver.getClass());
                }
            }
        };
        this.showReceiverHelpAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.HELP));
        this.showReceiverHelpAction.putValue("ShortDescription", "Displays the JavaDoc page for this Plugin");
        this.startAllAction = new AbstractAction("(Re)start All Receivers", new ImageIcon(ChainsawIcons.ICON_RESTART_ALL)){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(null, "This will cause any active Receiver to stop, and disconnect.  Is this ok?", "Confirm", 2) == 0) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            List allReceivers = ReceiversPanel.this.pluginRegistry.getPlugins(Receiver.class);
                            for (Receiver item : allReceivers) {
                                item.shutdown();
                                item.activateOptions();
                            }
                            ReceiversPanel.this.updateReceiverTreeInDispatchThread();
                            MessageCenter.getInstance().getLogger().info("All Receivers have been (re)started");
                        }
                    }).start();
                }
            }
        };
        this.startAllAction.putValue("ShortDescription", "Ensures that any Receiver that isn't active, is started, and any started action is stopped, and then restarted");
        this.receiversTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.receiversTree.setCellRenderer(new ReceiverTreeCellRenderer());
        this.receiversTree.setRowHeight(19);
        this.buttonPanel = new ReceiverToolbar();
        this.receiversTree.addTreeSelectionListener(this.buttonPanel);
        PopupListener popupListener = new PopupListener(this.popupMenu);
        this.receiversTree.addMouseListener(popupListener);
        this.addMouseListener(popupListener);
        JTree component = this.receiversTree;
        JScrollPane pane = new JScrollPane(component);
        this.splitter.setOrientation(0);
        this.splitter.setTopComponent(pane);
        this.splitter.setBottomComponent(this.pluginEditorPanel);
        this.splitter.setResizeWeight(0.7);
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.splitter, "Center");
        SocketNodeEventListener listener = new SocketNodeEventListener(){

            @Override
            public void socketOpened(String remoteInfo) {
                ReceiversPanel.this.updateReceiverTreeInDispatchThread();
            }

            @Override
            public void socketClosedEvent(Exception e) {
                ReceiversPanel.this.updateReceiverTreeInDispatchThread();
            }
        };
        if (this.pluginRegistry != null) {
            List socketReceivers = this.pluginRegistry.getPlugins(SocketReceiver.class);
            for (SocketReceiver element : socketReceivers) {
                element.addSocketNodeEventListener(listener);
            }
        }
    }

    private void saveReceivers() {
        File saveConfigFile = SwingHelper.promptForFile(this, null, "Save receiver configuration XML file", false);
        if (saveConfigFile != null) {
            ReceiversHelper.getInstance().saveReceiverConfiguration(saveConfigFile);
        }
    }

    protected ReceiversTreeModel getReceiverTreeModel() {
        return (ReceiversTreeModel)this.receiversTree.getModel();
    }

    protected void updateCurrentlySelectedNodeInDispatchThread() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ReceiversPanel.this.getReceiverTreeModel().nodeChanged(node);
                ReceiversPanel.this.updateActions();
            }
        });
    }

    private Receiver getCurrentlySelectedReceiver() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.receiversTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof Receiver) {
            return (Receiver)userObject;
        }
        return null;
    }

    private Receiver[] getSelectedReceivers() {
        TreePath[] paths = this.receiversTree.getSelectionPaths();
        ArrayList<Object> receivers = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null || !(node.getUserObject() instanceof Receiver)) continue;
            receivers.add(node.getUserObject());
        }
        return receivers.toArray(new Receiver[0]);
    }

    private Object getCurrentlySelectedUserObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.receiversTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private void pauseCurrentlySelectedReceiver() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Object obj = ReceiversPanel.this.getCurrentlySelectedUserObject();
                if (obj != null && obj instanceof Pauseable) {
                    ((Pauseable)obj).setPaused(true);
                    ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                }
            }
        }).start();
    }

    private void playCurrentlySelectedReceiver() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Object obj = ReceiversPanel.this.getCurrentlySelectedUserObject();
                if (obj != null && obj instanceof Pauseable) {
                    ((Pauseable)obj).setPaused(false);
                    ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                }
            }
        }).start();
    }

    private void shutdownCurrentlySelectedReceiver() {
        if (JOptionPane.showConfirmDialog(null, "Are you sure you wish to shutdown this receiver?\n\nThis will disconnect any network resources, and remove it from the PluginRegistry.", "Confirm stop of Receiver", 0) == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Receiver[] receivers = ReceiversPanel.this.getSelectedReceivers();
                    if (receivers != null) {
                        for (int i = 0; i < receivers.length; ++i) {
                            ReceiversPanel.this.pluginRegistry.stopPlugin(receivers[i].getName());
                        }
                    }
                }
            }).start();
        }
    }

    private void updateActions() {
        Object object = this.getCurrentlySelectedUserObject();
        if (object != null && object instanceof Pauseable) {
            Pauseable pauseable = (Pauseable)object;
            if (!pauseable.isPaused()) {
                this.pauseReceiverButtonAction.setEnabled(true);
                this.playReceiverButtonAction.setEnabled(false);
            } else {
                this.pauseReceiverButtonAction.setEnabled(false);
                this.playReceiverButtonAction.setEnabled(true);
            }
        } else {
            this.pauseReceiverButtonAction.setEnabled(false);
            this.playReceiverButtonAction.setEnabled(false);
        }
        if (object instanceof Receiver) {
            this.newReceiverButtonAction.setEnabled(true);
            this.shutdownReceiverButtonAction.setEnabled(true);
            this.restartReceiverButtonAction.setEnabled(true);
        } else {
            this.shutdownReceiverButtonAction.setEnabled(false);
            this.restartReceiverButtonAction.setEnabled(false);
        }
    }

    public void updateReceiverTreeInDispatchThread() {
        this.logger.debug("updateReceiverTreeInDispatchThread, should not be needed now");
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean oldValue = this.isVisible();
        super.setVisible(aFlag);
        this.firePropertyChange("visible", oldValue, this.isVisible());
    }

    @Override
    public void loadSettings(LoadSettingsEvent event) {
    }

    @Override
    public void saveSettings(SaveSettingsEvent event) {
        File file = new File(SettingsManager.getInstance().getSettingsDirectory(), "receiver-config.xml");
        ReceiversHelper.getInstance().saveReceiverConfiguration(file);
    }

    private class ReceiverToolbar
    extends JToolBar
    implements TreeSelectionListener {
        final SmallButton newReceiverButton;

        private ReceiverToolbar() {
            this.setFloatable(false);
            SmallButton restartReceiverButton = new SmallButton(ReceiversPanel.this.restartReceiverButtonAction);
            restartReceiverButton.setText(null);
            SmallButton shutdownReceiverButton = new SmallButton(ReceiversPanel.this.shutdownReceiverButtonAction);
            shutdownReceiverButton.setText(null);
            SmallButton saveReceiversButton = new SmallButton(ReceiversPanel.this.saveReceiversButtonAction);
            saveReceiversButton.setText(null);
            SmallButton restartAllButton = new SmallButton(ReceiversPanel.this.startAllAction);
            restartAllButton.setText(null);
            this.newReceiverButton = new SmallButton(ReceiversPanel.this.newReceiverButtonAction);
            this.newReceiverButton.setText(null);
            this.newReceiverButton.addMouseListener(new PopupListener(ReceiversPanel.this.newReceiverPopup));
            this.add(this.newReceiverButton);
            this.add(restartAllButton);
            this.addSeparator();
            this.add(restartReceiverButton);
            this.add(shutdownReceiverButton);
            this.add(saveReceiversButton);
            this.addSeparator();
            AbstractAction closeAction = new AbstractAction(null, LineIconFactory.createCloseIcon()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReceiversPanel.this.setVisible(false);
                }
            };
            closeAction.putValue("ShortDescription", "Closes the Receiver panel");
            this.add(Box.createHorizontalGlue());
            this.add(new SmallButton(closeAction));
            this.add(Box.createHorizontalStrut(5));
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ReceiversPanel.this.updateActions();
        }
    }

    class ReceiverPopupMenu
    extends JPopupMenu {
        ReceiverPopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object userObject = node.getUserObject();
            this.removeAll();
            if (userObject == this.getRootOfTree().getUserObject()) {
                this.buildForReceiversRoot();
            } else if (ReceiversPanel.this.getCurrentlySelectedReceiver() != null) {
                this.buildForReceiverNode();
            } else {
                return;
            }
            this.invalidate();
            this.validate();
            super.show(invoker, x, y);
        }

        private DefaultMutableTreeNode getRootOfTree() {
            return (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getModel().getRoot();
        }

        private void buildForReceiverNode() {
            this.add(ReceiversPanel.this.playReceiverButtonAction);
            this.add(ReceiversPanel.this.pauseReceiverButtonAction);
            this.add(ReceiversPanel.this.restartReceiverButtonAction);
            this.add(ReceiversPanel.this.shutdownReceiverButtonAction);
            this.add(ReceiversPanel.this.saveReceiversButtonAction);
            this.addSeparator();
            Receiver r = ReceiversPanel.this.getCurrentlySelectedReceiver();
            this.add(this.createLevelRadioButton(r, Level.TRACE));
            this.add(this.createLevelRadioButton(r, Level.DEBUG));
            this.add(this.createLevelRadioButton(r, Level.INFO));
            this.add(this.createLevelRadioButton(r, Level.WARN));
            this.add(this.createLevelRadioButton(r, Level.ERROR));
            this.addSeparator();
            this.add(this.createLevelRadioButton(r, Level.OFF));
            this.add(this.createLevelRadioButton(r, Level.ALL));
            this.addSeparator();
            this.add(ReceiversPanel.this.showReceiverHelpAction);
        }

        private JRadioButtonMenuItem createLevelRadioButton(final Receiver r, final Level l) {
            Map levelIconMap = LevelIconFactory.getInstance().getLevelToIconMap();
            AbstractAction action = new AbstractAction(l.toString(), (Icon)levelIconMap.get(l.toString())){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (r != null) {
                        r.setThreshold(l);
                        ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                    }
                }
            };
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setSelected(r.getThreshold() == l);
            return item;
        }

        private void buildForReceiversRoot() {
            JMenuItem startAll = new JMenuItem(ReceiversPanel.this.startAllAction);
            this.add(ReceiversPanel.this.newReceiverButtonAction);
            this.addSeparator();
            this.add(startAll);
        }
    }

    class NewReceiverPopupMenu
    extends JPopupMenu {
        NewReceiverPopupMenu() {
            try {
                List receiverList = ReceiversHelper.getInstance().getKnownReceiverClasses();
                String separatorCheck = null;
                for (final Class toCreate : receiverList) {
                    Package thePackage = toCreate.getPackage();
                    String name = toCreate.getName().substring(thePackage.getName().length() + 1);
                    if (separatorCheck == null) {
                        separatorCheck = name.substring(0, 1);
                    } else {
                        String current = name.substring(0, 1);
                        if (!current.equals(separatorCheck)) {
                            this.addSeparator();
                            separatorCheck = current;
                        }
                    }
                    this.add(new AbstractAction("New " + name + "..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Container container = SwingUtilities.getAncestorOfClass(JFrame.class, ReceiversPanel.this);
                            final JDialog dialog = new JDialog((JFrame)container, "New " + toCreate.getName() + "...", true);
                            try {
                                final NewReceiverDialogPanel panel = NewReceiverDialogPanel.create(toCreate);
                                dialog.getContentPane().add(panel);
                                dialog.pack();
                                SwingHelper.centerOnScreen(dialog);
                                dialog.getRootPane().setDefaultButton(panel.getOkPanel().getOkButton());
                                SwingHelper.configureCancelForDialog(dialog, panel.getOkPanel().getCancelButton());
                                panel.getOkPanel().getOkButton().addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e2) {
                                        Plugin plugin = panel.getPlugin();
                                        if (plugin.getName() != null && !plugin.getName().trim().equals("")) {
                                            dialog.dispose();
                                            ReceiversPanel.this.pluginRegistry.addPlugin(plugin);
                                            plugin.activateOptions();
                                            MessageCenter.getInstance().addMessage("Plugin '" + plugin.getName() + "' started");
                                        } else {
                                            MessageCenter.getInstance().getLogger().error("Name required to create receiver");
                                        }
                                    }
                                });
                                dialog.setVisible(true);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageCenter.getInstance().getLogger().error("Failed to create the new Receiver dialog", e1);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

