/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor;

import aQute.bnd.annotation.spi.ServiceProvider;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SimpleDocTreeVisitor;
import com.sun.source.util.Trees;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.docgen.AbstractType;
import org.apache.logging.log4j.docgen.Description;
import org.apache.logging.log4j.docgen.PluginAttribute;
import org.apache.logging.log4j.docgen.PluginElement;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.PluginType;
import org.apache.logging.log4j.docgen.ScalarType;
import org.apache.logging.log4j.docgen.ScalarValue;
import org.apache.logging.log4j.docgen.Type;
import org.apache.logging.log4j.docgen.io.stax.PluginBundleStaxWriter;
import org.apache.logging.log4j.docgen.processor.Annotations;
import org.apache.logging.log4j.docgen.processor.AsciiDocConverter;
import org.apache.logging.log4j.docgen.processor.ElementImports;
import org.apache.logging.log4j.docgen.processor.ElementImportsFactory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@SupportedAnnotationTypes(value={"org.apache.logging.log4j.core.config.plugins.*", "org.apache.logging.log4j.plugins.*"})
@SupportedOptions(value={"log4j.docgen.descriptorFilePath", "log4j.docgen.groupId", "log4j.docgen.artifactId", "log4j.docgen.version", "log4j.docgen.description", "log4j.docgen.typeFilter.includePattern", "log4j.docgen.typeFilter.excludePattern"})
@NullMarked
@ServiceProvider(value=Processor.class, resolution="optional")
public class DescriptorGenerator
extends AbstractProcessor {
    static final String DESCRIPTOR_FILE_PATH_OPTION_KEY = "log4j.docgen.descriptorFilePath";
    static final String GROUP_ID_OPTION_KEY = "log4j.docgen.groupId";
    static final String ARTIFACT_ID_OPTION_KEY = "log4j.docgen.artifactId";
    static final String VERSION_OPTION_KEY = "log4j.docgen.version";
    static final String DESCRIPTION_OPTION_KEY = "log4j.docgen.description";
    static final String TYPE_FILTER_INCLUDE_PATTERN_OPTION_KEY = "log4j.docgen.typeFilter.includePattern";
    static final String TYPE_FILTER_EXCLUDE_PATTERN_OPTION_KEY = "log4j.docgen.typeFilter.excludePattern";
    private static final String MULTIPLICITY_UNBOUNDED = "*";
    private static final CharSequence[] GETTER_SETTER_PREFIXES = new CharSequence[]{"get", "is", "set"};
    private static final Set<String> KNOWN_SCALAR_TYPES = Set.of("java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String");
    private static final String IMPOSSIBLE_REGEX = "(?!.*)";
    private final Set<TypeElement> pluginTypesToDocument = new HashSet<TypeElement>();
    private final Set<TypeElement> abstractTypesToDocument = new HashSet<TypeElement>();
    private final Set<TypeElement> scalarTypesToDocument = new HashSet<TypeElement>();
    private Predicate<String> classNameFilter;
    private PluginSet pluginSet;
    private Path descriptorFilePath;
    private DocTrees docTrees;
    private Elements elements;
    private Messager messager;
    private Types types;
    private ElementImportsFactory importsFactory;
    private AsciiDocConverter converter;
    private Annotations annotations;
    private DeclaredType collectionType;
    private DeclaredType enumType;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.classNameFilter = this.createClassNameFilter(processingEnv);
        this.pluginSet = DescriptorGenerator.createPluginSet(processingEnv);
        this.descriptorFilePath = Path.of(DescriptorGenerator.requireOption(processingEnv, DESCRIPTOR_FILE_PATH_OPTION_KEY), new String[0]);
        this.docTrees = DocTrees.instance(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.types = processingEnv.getTypeUtils();
        Trees trees = Trees.instance(processingEnv);
        this.importsFactory = ElementImports.factory(trees);
        this.converter = new AsciiDocConverter(this.docTrees);
        this.annotations = new Annotations(this.elements, this.types);
        this.collectionType = DescriptorGenerator.getDeclaredType(processingEnv, "java.util.Collection");
        this.enumType = DescriptorGenerator.getDeclaredType(processingEnv, "java.lang.Enum");
    }

    private Predicate<String> createClassNameFilter(ProcessingEnvironment processingEnv) {
        Pattern includePattern = DescriptorGenerator.getPatternOption(processingEnv, TYPE_FILTER_INCLUDE_PATTERN_OPTION_KEY, ".*");
        Pattern excludePattern = DescriptorGenerator.getPatternOption(processingEnv, TYPE_FILTER_EXCLUDE_PATTERN_OPTION_KEY, IMPOSSIBLE_REGEX);
        return className -> includePattern.matcher((CharSequence)className).matches() && !excludePattern.matcher((CharSequence)className).matches();
    }

    private static Pattern getPatternOption(ProcessingEnvironment processingEnv, String key, String defaultValue) {
        @Nullable String regex = DescriptorGenerator.getOption(processingEnv, key);
        String effectiveRegex = regex != null ? regex : defaultValue;
        try {
            return Pattern.compile(effectiveRegex);
        }
        catch (Exception error) {
            String message = String.format("failed compiling the regex pattern `%s` provided in option `%s`", regex, key);
            throw new IllegalArgumentException(message, error);
        }
    }

    private static PluginSet createPluginSet(ProcessingEnvironment processingEnv) {
        PluginSet pluginSet = new PluginSet();
        String groupId = DescriptorGenerator.requireOption(processingEnv, GROUP_ID_OPTION_KEY);
        String artifactId = DescriptorGenerator.requireOption(processingEnv, ARTIFACT_ID_OPTION_KEY);
        @Nullable String version = DescriptorGenerator.getOption(processingEnv, VERSION_OPTION_KEY);
        @Nullable String description = DescriptorGenerator.getOption(processingEnv, DESCRIPTION_OPTION_KEY);
        pluginSet.setGroupId(groupId);
        pluginSet.setArtifactId(artifactId);
        pluginSet.setVersion(version);
        if (description != null) {
            Description descriptionModel = new Description();
            descriptionModel.setText(description);
            pluginSet.setDescription(descriptionModel);
        }
        return pluginSet;
    }

    private static String requireOption(ProcessingEnvironment processingEnv, String key) {
        @Nullable String value = DescriptorGenerator.getOption(processingEnv, key);
        if (value == null) {
            String message = String.format("missing option: `%s`", key);
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    private static @Nullable String getOption(ProcessingEnvironment processingEnv, String key) {
        @Nullable String value = processingEnv.getOptions().get(key);
        return StringUtils.isBlank((CharSequence)value) ? null : value.trim();
    }

    private static DeclaredType getDeclaredType(ProcessingEnvironment processingEnv, String className) {
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        return (DeclaredType)typeUtils.erasure(elementUtils.getTypeElement(className).asType());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> unused, RoundEnvironment roundEnv) {
        this.populatePluginTypesToDocument(roundEnv);
        this.pluginTypesToDocument.forEach(this::addPluginDocumentation);
        this.abstractTypesToDocument.forEach(this::addAbstractTypeDocumentation);
        this.scalarTypesToDocument.forEach(this::addScalarTypeDocumentation);
        if (roundEnv.processingOver()) {
            this.writePluginDescriptor();
        }
        return false;
    }

    private void populatePluginTypesToDocument(RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWithAny(this.annotations.getPluginAnnotations()).forEach(element -> {
            if (element instanceof TypeElement) {
                this.pluginTypesToDocument.add((TypeElement)element);
            } else {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Found @Plugin annotation on unexpected element.", (Element)element);
            }
        });
    }

    private void addPluginDocumentation(TypeElement element) {
        try {
            PluginType pluginType = new PluginType();
            pluginType.setName(this.annotations.getPluginSpecifiedName(element).orElseGet(() -> element.getSimpleName().toString()));
            pluginType.setNamespace(this.annotations.getPluginSpecifiedNamespace(element).orElse("Core"));
            this.populatePlugin(element, pluginType);
            this.pluginSet.addPlugin(pluginType);
        }
        catch (Exception error) {
            String message = String.format("failed to process element `%s`", element);
            throw new RuntimeException(message, error);
        }
    }

    private void addAbstractTypeDocumentation(QualifiedNameable element) {
        try {
            if (this.pluginTypesToDocument.contains(element)) {
                return;
            }
            AbstractType abstractType = new AbstractType();
            ElementImports imports = this.importsFactory.ofElement(element);
            String qualifiedClassName = this.getClassName(element.asType());
            this.populateType(element, imports, qualifiedClassName, abstractType);
            boolean filtered = this.classNameFilter.test(abstractType.getClassName());
            if (filtered) {
                this.pluginSet.addAbstractType(abstractType);
            }
        }
        catch (Exception error) {
            String message = String.format("failed to process element `%s`", element);
            throw new RuntimeException(message, error);
        }
    }

    private void addScalarTypeDocumentation(TypeElement element) {
        try {
            ScalarType scalarType = new ScalarType();
            this.populateScalarType(element, scalarType);
            this.pluginSet.addScalar(scalarType);
        }
        catch (Exception error) {
            String message = String.format("failed to process element `%s`", element);
            throw new RuntimeException(message, error);
        }
    }

    private void writePluginDescriptor() {
        try {
            @Nullable Path descriptorFileParentPath = this.descriptorFilePath.getParent();
            if (descriptorFileParentPath != null) {
                Files.createDirectories(descriptorFileParentPath, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.descriptorFilePath, new OpenOption[0]);){
                new PluginBundleStaxWriter().write(writer, this.pluginSet);
            }
        }
        catch (IOException | XMLStreamException error) {
            String message = String.format("failed to write to `%s`", this.descriptorFilePath);
            throw new RuntimeException(message, error);
        }
    }

    private void populateType(QualifiedNameable element, ElementImports imports, String qualifiedClassName, Type docgenType) {
        docgenType.setClassName(element.getQualifiedName().toString());
        docgenType.setDescription(this.createDescription(element, imports, qualifiedClassName, null));
    }

    private void populateScalarType(TypeElement element, ScalarType scalarType) {
        String qualifiedClassName = this.getClassName(element.asType());
        ElementImports imports = this.importsFactory.ofElement(element);
        this.populateType(element, imports, qualifiedClassName, scalarType);
        if (this.types.isSubtype(element.asType(), this.enumType)) {
            for (Element element2 : element.getEnclosedElements()) {
                if (!(element2 instanceof VariableElement) || !element2.getModifiers().contains((Object)Modifier.STATIC) || !this.types.isSameType(element2.asType(), element.asType())) continue;
                VariableElement field = (VariableElement)element2;
                ScalarValue value = new ScalarValue();
                value.setDescription(this.createDescription(field, imports, qualifiedClassName, null));
                value.setName(field.getSimpleName().toString());
                scalarType.addValue(value);
            }
        }
    }

    private Map<String, String> getParameterDescriptions(Element element, final ElementImports imports, final String qualifiedClassName) {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        DocCommentTree docCommentTree = this.docTrees.getDocCommentTree(element);
        if (docCommentTree != null) {
            docCommentTree.accept(new SimpleDocTreeVisitor<Void, Map<String, String>>(){

                @Override
                public Void visitDocComment(DocCommentTree node, Map<String, String> descriptions) {
                    for (DocTree docTree : node.getBlockTags()) {
                        docTree.accept(this, descriptions);
                    }
                    return null;
                }

                @Override
                public Void visitParam(ParamTree paramTree, Map<String, String> descriptions) {
                    String name = paramTree.getName().getName().toString();
                    descriptions.put(name, StringUtils.defaultString((String)DescriptorGenerator.this.converter.toAsciiDoc(paramTree, imports, qualifiedClassName)));
                    return null;
                }
            }, descriptions);
        }
        return descriptions;
    }

    private void populatePlugin(TypeElement element, PluginType pluginType) {
        ElementImports imports = this.importsFactory.ofElement(element);
        String qualifiedClassName = element.getQualifiedName().toString();
        this.populateType(element, imports, qualifiedClassName, pluginType);
        this.registerSupertypes(element).forEach(pluginType::addSupertype);
        for (Element element2 : element.getEnclosedElements()) {
            if (!(element2 instanceof ExecutableElement) || this.annotations.hasDeprecatedAnnotation(element2) || !this.annotations.hasFactoryAnnotation(element2)) continue;
            ExecutableElement executable = (ExecutableElement)element2;
            Map<String, String> descriptions = this.getParameterDescriptions(executable, imports, qualifiedClassName);
            List<? extends VariableElement> parameters = executable.getParameters();
            if (parameters.isEmpty()) {
                TypeElement returnType = this.getReturnType(executable);
                if (returnType != null) {
                    this.populateConfigurationProperties(imports, qualifiedClassName, this.getAllMembers(returnType), descriptions, pluginType);
                    continue;
                }
                this.messager.printMessage(Diagnostic.Kind.WARNING, "The return type of a @PluginFactory annotated method should be a concrete class.", element2);
                continue;
            }
            this.populateConfigurationProperties(imports, qualifiedClassName, parameters, descriptions, pluginType);
        }
    }

    private void populateConfigurationProperties(ElementImports imports, String qualifiedClassName, Iterable<? extends Element> members, Map<? super String, String> descriptions, PluginType pluginType) {
        TreeSet<PluginAttribute> pluginAttributes = new TreeSet<PluginAttribute>(Comparator.comparing(a -> StringUtils.defaultString((String)a.getName())));
        TreeSet<PluginElement> pluginElements = new TreeSet<PluginElement>(Comparator.comparing(e -> StringUtils.defaultString((String)e.getType())));
        for (Element element : members) {
            String name = this.getAttributeOrPropertyName(element);
            String asciiDoc = this.converter.toAsciiDoc(element, imports, qualifiedClassName);
            descriptions.compute(name, (key, value) -> Stream.of(value, asciiDoc).filter(StringUtils::isNotEmpty).collect(Collectors.joining("\n")));
        }
        for (Element element : members) {
            String description = descriptions.get(this.getAttributeOrPropertyName(element));
            for (AnnotationMirror annotationMirror : this.annotations.findAttributeAndPropertyAnnotations(element)) {
                if (this.annotations.isAttributeAnnotation(annotationMirror)) {
                    pluginAttributes.add(this.createPluginAttribute(element, imports, qualifiedClassName, description, this.annotations.getAttributeSpecifiedName(annotationMirror).orElseGet(() -> this.getAttributeOrPropertyName(member))));
                    continue;
                }
                pluginElements.add(this.createPluginElement(element, imports, qualifiedClassName, description));
            }
        }
        pluginAttributes.forEach(pluginType::addAttribute);
        pluginElements.forEach(pluginType::addElement);
    }

    private @Nullable Description createDescription(Element element, ElementImports imports, String qualifiedClassName, @Nullable String fallbackDescriptionText) {
        @Nullable String descriptionText = this.converter.toAsciiDoc(element, imports, qualifiedClassName);
        if (StringUtils.isBlank((CharSequence)descriptionText)) {
            if (StringUtils.isBlank((CharSequence)fallbackDescriptionText)) {
                return null;
            }
            descriptionText = fallbackDescriptionText;
        }
        descriptionText = descriptionText.trim();
        Description description = new Description();
        description.setText(descriptionText);
        return description;
    }

    private PluginAttribute createPluginAttribute(Element element, ElementImports imports, String qualifiedClassName, String description, String specifiedName) {
        Object defaultValue;
        PluginAttribute attribute = new PluginAttribute();
        attribute.setName(specifiedName.isEmpty() ? this.getAttributeOrPropertyName(element) : specifiedName);
        TypeMirror type = this.getMemberType(element);
        String className = this.getClassName(type);
        if (className != null && !KNOWN_SCALAR_TYPES.contains(className) && type instanceof DeclaredType) {
            this.scalarTypesToDocument.add(this.asTypeElement((DeclaredType)type));
        }
        attribute.setType(className);
        attribute.setDescription(this.createDescription(element, imports, qualifiedClassName, description));
        attribute.setRequired(this.annotations.hasRequiredConstraint(element));
        Object object = defaultValue = element instanceof VariableElement ? ((VariableElement)element).getConstantValue() : null;
        if (defaultValue != null) {
            attribute.setDefaultValue(this.elements.getConstantExpression(defaultValue));
        }
        return attribute;
    }

    private PluginElement createPluginElement(Element element, ElementImports imports, String qualifiedClassName, String description) {
        PluginElement pluginElement = new PluginElement();
        TypeMirror elementType = this.getMemberType(element);
        if (elementType == null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Unable to determine type of plugin element.", element);
        } else {
            pluginElement.setType(this.getComponentClassName(elementType));
            pluginElement.setMultiplicity(this.getMultiplicity(elementType));
        }
        pluginElement.setRequired(this.annotations.hasRequiredConstraint(element));
        pluginElement.setDescription(this.createDescription(element, imports, qualifiedClassName, description));
        return pluginElement;
    }

    private Set<String> registerSupertypes(TypeElement element) {
        TreeSet<String> supertypes = new TreeSet<String>();
        element.accept(new SimpleElementVisitor8<Void, Set<String>>(){

            @Override
            public Void visitType(TypeElement element, Set<String> supertypes) {
                this.registerAndVisit(element.getSuperclass(), supertypes);
                element.getInterfaces().forEach(iface -> this.registerAndVisit((TypeMirror)iface, supertypes));
                return null;
            }

            private void registerAndVisit(TypeMirror type, Set<String> supertypes) {
                if (type instanceof DeclaredType) {
                    TypeElement element = DescriptorGenerator.this.asTypeElement((DeclaredType)type);
                    String className = element.getQualifiedName().toString();
                    DescriptorGenerator.this.abstractTypesToDocument.add(element);
                    if (supertypes.add(className)) {
                        element.accept(this, supertypes);
                    }
                }
            }
        }, supertypes);
        return supertypes;
    }

    private @Nullable TypeMirror getMemberType(Element element) {
        return element.accept(new SimpleElementVisitor8<TypeMirror, Void>(){

            @Override
            protected @Nullable TypeMirror defaultAction(Element element, Void unused) {
                DescriptorGenerator.this.messager.printMessage(Diagnostic.Kind.WARNING, "Unexpected plugin annotation on element of type " + element.getKind().name(), element);
                return null;
            }

            @Override
            public TypeMirror visitVariable(VariableElement element, Void unused) {
                return element.asType();
            }

            @Override
            public @Nullable TypeMirror visitExecutable(ExecutableElement element, Void unused) {
                TypeMirror returnType = element.getReturnType();
                List<? extends VariableElement> parameters = element.getParameters();
                switch (parameters.size()) {
                    case 0: {
                        return returnType;
                    }
                    case 1: {
                        return parameters.get(0).asType();
                    }
                }
                return (TypeMirror)super.visitExecutable(element, unused);
            }
        }, null);
    }

    private String getAttributeOrPropertyName(Element element) {
        return element.accept(new SimpleElementVisitor8<String, Void>(){

            @Override
            protected String defaultAction(Element e, @Nullable Void unused) {
                return e.getSimpleName().toString();
            }

            @Override
            public String visitExecutable(ExecutableElement e, Void unused) {
                Name name = e.getSimpleName();
                if (StringUtils.startsWithAny((CharSequence)name, (CharSequence[])GETTER_SETTER_PREFIXES)) {
                    int prefixLen;
                    int n = prefixLen = StringUtils.startsWith((CharSequence)name, (CharSequence)"is") ? 2 : 3;
                    if (name.length() > prefixLen) {
                        return Character.toLowerCase(name.charAt(prefixLen)) + name.toString().substring(prefixLen + 1);
                    }
                }
                return (String)super.visitExecutable(e, unused);
            }
        }, null);
    }

    private @Nullable TypeElement getReturnType(ExecutableElement method) {
        return method.getReturnType().accept(new SimpleTypeVisitor8<TypeElement, Void>(){

            @Override
            public TypeElement visitDeclared(DeclaredType t, Void unused) {
                return DescriptorGenerator.this.asTypeElement(t);
            }

            @Override
            public @Nullable TypeElement visitTypeVariable(TypeVariable t, Void unused) {
                return t.getUpperBound().accept(this, unused);
            }
        }, null);
    }

    private Collection<? extends Element> getAllMembers(TypeElement element) {
        HashSet<? extends Element> members = new HashSet<Element>();
        TypeElement currentElement = element;
        while (currentElement != null) {
            members.addAll(currentElement.getEnclosedElements());
            currentElement = this.getSuperclass(currentElement);
        }
        return members;
    }

    private @Nullable TypeElement getSuperclass(TypeElement element) {
        TypeMirror superclass = element.getSuperclass();
        return superclass instanceof DeclaredType ? this.asTypeElement((DeclaredType)superclass) : null;
    }

    private TypeElement asTypeElement(DeclaredType type) {
        return (TypeElement)type.asElement();
    }

    private @Nullable String getClassName(@Nullable TypeMirror type) {
        return type != null ? this.types.erasure(type).accept(new SimpleTypeVisitor8<String, Void>(){

            @Override
            public String visitDeclared(DeclaredType t, Void unused) {
                return DescriptorGenerator.this.asTypeElement(t).getQualifiedName().toString();
            }

            @Override
            public String visitPrimitive(PrimitiveType t, Void unused) {
                switch (t.getKind()) {
                    case BOOLEAN: {
                        return "boolean";
                    }
                    case BYTE: {
                        return "byte";
                    }
                    case SHORT: {
                        return "short";
                    }
                    case INT: {
                        return "int";
                    }
                    case LONG: {
                        return "long";
                    }
                    case CHAR: {
                        return "char";
                    }
                    case FLOAT: {
                        return "float";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            public String visitNoType(NoType t, Void unused) {
                return "void";
            }
        }, null) : null;
    }

    private @Nullable String getComponentClassName(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<String, Void>(){

            @Override
            protected @Nullable String defaultAction(TypeMirror e, Void unused) {
                return DescriptorGenerator.this.getClassName(e);
            }

            @Override
            public @Nullable String visitArray(ArrayType t, Void unused) {
                return DescriptorGenerator.this.getClassName(t.getComponentType());
            }

            @Override
            public @Nullable String visitDeclared(DeclaredType t, Void unused) {
                List<? extends TypeMirror> typeArguments;
                DeclaredType asCollection;
                if (DescriptorGenerator.this.types.isAssignable(t, DescriptorGenerator.this.collectionType) && (asCollection = this.findCollectionSupertype(t)) != null && !(typeArguments = asCollection.getTypeArguments()).isEmpty()) {
                    return DescriptorGenerator.this.getClassName(typeArguments.get(0));
                }
                return (String)super.visitDeclared(t, unused);
            }

            private @Nullable DeclaredType findCollectionSupertype(TypeMirror type) {
                if (DescriptorGenerator.this.types.isSameType(DescriptorGenerator.this.types.erasure(type), DescriptorGenerator.this.collectionType)) {
                    return (DeclaredType)type;
                }
                for (TypeMirror typeMirror : DescriptorGenerator.this.types.directSupertypes(type)) {
                    DeclaredType result = this.findCollectionSupertype(typeMirror);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        }, null);
    }

    private @Nullable String getMultiplicity(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<String, Void>(){

            @Override
            public String visitArray(ArrayType t, Void unused) {
                return DescriptorGenerator.MULTIPLICITY_UNBOUNDED;
            }

            @Override
            public @Nullable String visitDeclared(DeclaredType t, Void unused) {
                return DescriptorGenerator.this.types.isAssignable(t, DescriptorGenerator.this.collectionType) ? DescriptorGenerator.MULTIPLICITY_UNBOUNDED : null;
            }
        }, null);
    }
}

