/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.maven;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Parameter;
import org.jspecify.annotations.Nullable;

public final class PathMatcherMojo {
    @Parameter(required=true)
    private File baseDirectory;
    @Parameter(defaultValue="true")
    private boolean dotFilesExcluded = true;
    @Parameter
    private @Nullable String[] pathPatterns;

    void findPaths(Consumer<Path> pathConsumer) {
        String[] effectivePathPatterns = this.pathPatterns != null ? this.pathPatterns : new String[]{};
        FileSystem fileSystem = FileSystems.getDefault();
        Set pathMatchers = Arrays.stream(effectivePathPatterns).map(pathPattern -> {
            try {
                return fileSystem.getPathMatcher((String)pathPattern);
            }
            catch (Exception error) {
                String message = String.format("failed to create matcher using path pattern `%s`", pathPattern);
                throw new IllegalArgumentException(message, error);
            }
        }).collect(Collectors.toSet());
        try (Stream<Path> paths = Files.walk(this.baseDirectory.toPath(), new FileVisitOption[0]);){
            paths.filter(path -> {
                boolean dotFile;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return false;
                }
                boolean bl = dotFile = this.dotFilesExcluded && path.getFileName().toString().startsWith(".");
                if (dotFile) {
                    return false;
                }
                return pathMatchers.isEmpty() || pathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches((Path)path));
            }).forEach(pathConsumer);
        }
        catch (IOException error) {
            String message = String.format("failed walking directory: `%s`", this.baseDirectory);
            throw new UncheckedIOException(message, error);
        }
    }
}

