/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.memory.MemoryDocValuesConsumer;
import org.apache.lucene.codecs.memory.MemoryDocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class MemoryDocValuesFormat
extends DocValuesFormat {
    public static final int MAX_BINARY_FIELD_LENGTH = 32766;
    final float acceptableOverheadRatio;
    static final String DATA_CODEC = "MemoryDocValuesData";
    static final String DATA_EXTENSION = "mdvd";
    static final String METADATA_CODEC = "MemoryDocValuesMetadata";
    static final String METADATA_EXTENSION = "mdvm";

    public MemoryDocValuesFormat() {
        this(0.2f);
    }

    public MemoryDocValuesFormat(float acceptableOverheadRatio) {
        super("Memory");
        this.acceptableOverheadRatio = acceptableOverheadRatio;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new MemoryDocValuesConsumer(state, DATA_CODEC, DATA_EXTENSION, METADATA_CODEC, METADATA_EXTENSION, this.acceptableOverheadRatio);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new MemoryDocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, METADATA_CODEC, METADATA_EXTENSION);
    }
}

