/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete.index;

import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.delete.index.ShardDeleteRequest;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardDeleteAction
extends TransportShardReplicationOperationAction<ShardDeleteRequest, ShardDeleteRequest, ShardDeleteResponse> {
    @Inject
    public TransportShardDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected ShardDeleteRequest newRequestInstance() {
        return new ShardDeleteRequest();
    }

    @Override
    protected ShardDeleteRequest newReplicaRequestInstance() {
        return new ShardDeleteRequest();
    }

    @Override
    protected ShardDeleteResponse newResponseInstance() {
        return new ShardDeleteResponse();
    }

    @Override
    protected String transportAction() {
        return "indices/index/b_shard/delete";
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ShardDeleteRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ShardDeleteRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteResponse, ShardDeleteRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        ShardDeleteRequest request = (ShardDeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((ShardDeleteRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).origin(Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        request.version(delete.version());
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh("refresh_flag_delete").force(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ShardDeleteResponse response = new ShardDeleteResponse(delete.version(), delete.found());
        return new TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteResponse, ShardDeleteRequest>((ShardDeleteRequest)shardRequest.request, response, null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        ShardDeleteRequest request = (ShardDeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((ShardDeleteRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).origin(Engine.Operation.Origin.REPLICA);
        indexShard.delete(delete);
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh("refresh_flag_delete").force(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, ShardDeleteRequest request) {
        GroupShardsIterator group = this.clusterService.operationRouting().broadcastDeleteShards(this.clusterService.state(), request.index());
        for (ShardIterator shardIt : group) {
            if (shardIt.shardId().id() != request.shardId()) continue;
            return shardIt;
        }
        throw new ElasticsearchIllegalStateException("No shards iterator found for shard [" + request.shardId() + "]");
    }
}

