/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAcl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAllowableActions;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomBase;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.HtmlDoc;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.RepositoryWorkspace;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.ServiceDoc;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;

public class AtomPubParser {
    public static final String LINK_REL_CONTENT = "@@content@@";
    private final InputStream stream;
    private AtomBase parseResult;

    public AtomPubParser(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("No stream.");
        }
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws XMLStreamException {
        XMLStreamReader parser = XMLUtils.createParser((InputStream)this.stream);
        try {
            do {
                int event;
                if ((event = parser.getEventType()) != 1) continue;
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("feed".equals(name.getLocalPart())) {
                        this.parseResult = this.parseFeed(parser);
                    } else {
                        if (!"entry".equals(name.getLocalPart())) continue;
                        this.parseResult = this.parseEntry(parser);
                    }
                } else if ("http://docs.oasis-open.org/ns/cmis/core/200908/".equals(name.getNamespaceURI())) {
                    if ("allowableActions".equals(name.getLocalPart())) {
                        this.parseResult = AtomPubParser.parseAllowableActions(parser);
                    } else {
                        if (!"acl".equals(name.getLocalPart())) continue;
                        this.parseResult = AtomPubParser.parseACL(parser);
                    }
                } else if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI())) {
                    if (!"service".equals(name.getLocalPart())) continue;
                    this.parseResult = AtomPubParser.parseServiceDoc(parser);
                } else {
                    if (!"html".equalsIgnoreCase(name.getLocalPart())) continue;
                    this.parseResult = new HtmlDoc();
                }
                break;
            } while (XMLUtils.next((XMLStreamReader)parser));
        }
        finally {
            try {
                parser.close();
            }
            catch (XMLStreamException xMLStreamException) {}
            IOUtils.consumeAndClose((InputStream)this.stream);
        }
    }

    public AtomBase getResults() {
        return this.parseResult;
    }

    private static ServiceDoc parseServiceDoc(XMLStreamReader parser) throws XMLStreamException {
        ServiceDoc result = new ServiceDoc();
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI())) {
                    if ("workspace".equals(name.getLocalPart())) {
                        result.addWorkspace(AtomPubParser.parseWorkspace(parser));
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                XMLUtils.skip((XMLStreamReader)parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        return result;
    }

    private static RepositoryWorkspace parseWorkspace(XMLStreamReader parser) throws XMLStreamException {
        RepositoryWorkspace workspace = new RepositoryWorkspace();
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                AtomElement element = AtomPubParser.parseWorkspaceElement(parser);
                if (element != null && element.getObject() instanceof RepositoryInfo) {
                    workspace.setId(((RepositoryInfo)element.getObject()).getId());
                }
                workspace.addElement(element);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return workspace;
    }

    private AtomFeed parseFeed(XMLStreamReader parser) throws XMLStreamException {
        AtomFeed result = new AtomFeed();
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("link".equals(name.getLocalPart())) {
                        result.addElement(AtomPubParser.parseLink(parser));
                        continue;
                    }
                    if ("entry".equals(name.getLocalPart())) {
                        result.addEntry(this.parseEntry(parser));
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if ("numItems".equals(name.getLocalPart())) {
                        result.addElement(AtomPubParser.parseBigInteger(parser));
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                if ("http://chemistry.apache.org/".equals(name.getNamespaceURI())) {
                    result.addElement(AtomPubParser.parseText(parser));
                    continue;
                }
                XMLUtils.skip((XMLStreamReader)parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return result;
    }

    private AtomEntry parseEntry(XMLStreamReader parser) throws XMLStreamException {
        AtomEntry result = new AtomEntry();
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                AtomElement element = this.parseElement(parser);
                if (element == null) continue;
                result.addElement(element);
                if (element.getObject() instanceof ObjectData) {
                    result.setId(((ObjectData)element.getObject()).getId());
                    continue;
                }
                if (!(element.getObject() instanceof TypeDefinition)) continue;
                result.setId(((TypeDefinition)element.getObject()).getId());
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return result;
    }

    private static AtomAllowableActions parseAllowableActions(XMLStreamReader parser) throws XMLStreamException {
        return new AtomAllowableActions(XMLConverter.convertAllowableActions((XMLStreamReader)parser));
    }

    private static AtomAcl parseACL(XMLStreamReader parser) throws XMLStreamException {
        return new AtomAcl(XMLConverter.convertAcl((XMLStreamReader)parser));
    }

    private AtomElement parseElement(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("object".equals(name.getLocalPart())) {
                return new AtomElement(name, XMLConverter.convertObject((XMLStreamReader)parser));
            }
            if ("pathSegment".equals(name.getLocalPart()) || "relativePathSegment".equals(name.getLocalPart())) {
                return AtomPubParser.parseText(parser);
            }
            if ("type".equals(name.getLocalPart())) {
                return new AtomElement(name, XMLConverter.convertTypeDefinition((XMLStreamReader)parser));
            }
            if ("children".equals(name.getLocalPart())) {
                return this.parseChildren(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return AtomPubParser.parseLink(parser);
            }
            if ("content".equals(name.getLocalPart())) {
                return AtomPubParser.parseAtomContentSrc(parser);
            }
        }
        XMLUtils.skip((XMLStreamReader)parser);
        return null;
    }

    private AtomElement parseChildren(XMLStreamReader parser) throws XMLStreamException {
        AtomElement result = null;
        QName childName = parser.getName();
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("feed".equals(name.getLocalPart())) {
                        result = new AtomElement(childName, this.parseFeed(parser));
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                XMLUtils.skip((XMLStreamReader)parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return result;
    }

    private static AtomElement parseWorkspaceElement(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("repositoryInfo".equals(name.getLocalPart())) {
                return new AtomElement(name, XMLConverter.convertRepositoryInfo((XMLStreamReader)parser));
            }
            if ("uritemplate".equals(name.getLocalPart())) {
                return AtomPubParser.parseTemplate(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return AtomPubParser.parseLink(parser);
            }
        } else if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI()) && "collection".equals(name.getLocalPart())) {
            return AtomPubParser.parseCollection(parser);
        }
        XMLUtils.skip((XMLStreamReader)parser);
        return null;
    }

    private static AtomElement parseCollection(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("href", parser.getAttributeValue(null, "href"));
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName tagName = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI()) && "collectionType".equals(tagName.getLocalPart())) {
                    result.put("collectionType", XMLUtils.readText((XMLStreamReader)parser, (int)102400));
                    continue;
                }
                XMLUtils.skip((XMLStreamReader)parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseTemplate(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName tagName = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI())) {
                    if ("template".equals(tagName.getLocalPart())) {
                        result.put("template", XMLUtils.readText((XMLStreamReader)parser, (int)102400));
                        continue;
                    }
                    if ("type".equals(tagName.getLocalPart())) {
                        result.put("type", XMLUtils.readText((XMLStreamReader)parser, (int)102400));
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                XMLUtils.skip((XMLStreamReader)parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseLink(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        AtomLink result = new AtomLink();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if ("rel".equals(parser.getAttributeLocalName(i))) {
                result.setRel(parser.getAttributeValue(i));
                continue;
            }
            if ("href".equals(parser.getAttributeLocalName(i))) {
                result.setHref(parser.getAttributeValue(i));
                continue;
            }
            if (!"type".equals(parser.getAttributeLocalName(i))) continue;
            result.setType(parser.getAttributeValue(i));
        }
        XMLUtils.skip((XMLStreamReader)parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseAtomContentSrc(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        AtomLink result = new AtomLink();
        result.setRel(LINK_REL_CONTENT);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!"src".equals(parser.getAttributeLocalName(i))) continue;
            result.setHref(parser.getAttributeValue(i));
        }
        XMLUtils.skip((XMLStreamReader)parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseText(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        return new AtomElement(name, XMLUtils.readText((XMLStreamReader)parser, (int)102400));
    }

    private static AtomElement parseBigInteger(XMLStreamReader parser) throws XMLStreamException {
        QName name = parser.getName();
        return new AtomElement(name, new BigInteger(XMLUtils.readText((XMLStreamReader)parser, (int)102400)));
    }
}

