/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.amazons3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.manifoldcf.crawler.system.Logging;

public class XThreadBuffer<T> {
    protected static int MAX_SIZE = 1024;
    protected List<T> buffer = Collections.synchronizedList(new ArrayList(MAX_SIZE));
    protected boolean complete = false;
    protected boolean abandoned = false;

    public synchronized void add(T t) throws InterruptedException {
        while (this.buffer.size() == MAX_SIZE && !this.abandoned) {
            this.wait();
        }
        if (this.abandoned) {
            return;
        }
        this.buffer.add(t);
        this.notifyAll();
    }

    public synchronized void abandon() {
        this.abandoned = true;
        this.notifyAll();
    }

    public synchronized T fetch() throws InterruptedException {
        while (this.buffer.size() == 0 && !this.complete) {
            if (Logging.connectors != null) {
                Logging.connectors.info((Object)"thread will be put to wait");
            }
            this.wait();
        }
        if (this.buffer.size() == 0) {
            return null;
        }
        boolean isBufferFull = this.buffer.size() == MAX_SIZE;
        T rval = this.buffer.remove(this.buffer.size() - 1);
        if (isBufferFull) {
            this.notifyAll();
        }
        return rval;
    }

    public synchronized void signalDone() {
        this.complete = true;
        this.notifyAll();
    }
}

