/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.Arrays;
import java.util.EventListener;
import org.apache.sis.util.ArraysExt;

public abstract class SystemListener
implements EventListener {
    private static SystemListener[] listeners;
    private final String module;

    protected SystemListener(String string) {
        this.module = string;
    }

    public static synchronized void add(SystemListener systemListener) {
        assert (systemListener != null && !ArraysExt.contains(listeners, systemListener));
        SystemListener[] systemListenerArray = listeners;
        systemListenerArray = systemListenerArray == null ? new SystemListener[1] : Arrays.copyOf(systemListenerArray, systemListenerArray.length + 1);
        systemListenerArray[systemListenerArray.length - 1] = systemListener;
        listeners = systemListenerArray;
    }

    public static synchronized void remove(SystemListener systemListener) {
        SystemListener[] systemListenerArray = listeners;
        if (systemListenerArray != null) {
            int n = systemListenerArray.length;
            while (--n >= 0) {
                if (systemListenerArray[n] != systemListener) continue;
                systemListenerArray = ArraysExt.remove(systemListenerArray, n, 1);
            }
            listeners = systemListenerArray;
        }
    }

    static synchronized void removeModule(String string) {
        SystemListener[] systemListenerArray;
        if (string != null && (systemListenerArray = listeners) != null) {
            int n = 0;
            SystemListener[] systemListenerArray2 = new SystemListener[systemListenerArray.length];
            for (SystemListener systemListener : systemListenerArray) {
                if (string.equals(systemListener.module)) continue;
                systemListenerArray2[n++] = systemListener;
            }
            if (n != systemListenerArray.length) {
                listeners = Arrays.copyOf(systemListenerArray2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireClasspathChanged() {
        Class<SystemListener> clazz = SystemListener.class;
        synchronized (SystemListener.class) {
            SystemListener[] systemListenerArray = listeners;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (systemListenerArray != null) {
                for (int i = 0; i < systemListenerArray.length; ++i) {
                    systemListenerArray[i].classpathChanged();
                }
            }
            return;
        }
    }

    protected abstract void classpathChanged();

    protected void databaseChanged() {
    }
}

