/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.csv;

import java.nio.charset.Charset;
import org.apache.sis.feature.FoliationRepresentation;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.csv.Store;
import org.apache.sis.internal.storage.wkt.FirstKeywordPeek;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@StoreMetadata(formatName="CSV", fileSuffixes={"csv"}, capabilities={Capability.READ}, resourceTypes={FeatureSet.class})
public final class StoreProvider
extends URIDataStore.Provider {
    static final String NAME = "CSV";
    static final String MOVING = "CSV-MF";
    private static final ParameterDescriptor<FoliationRepresentation> FOLIATION;

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        return new Peek().probeContent(storageConnector);
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new Store(this, storageConnector);
    }

    @Override
    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameter", parameterValueGroup);
        StorageConnector storageConnector = StoreProvider.connector(this, parameterValueGroup);
        Parameters parameters = Parameters.castOrWrap((ParameterValueGroup)parameterValueGroup);
        storageConnector.setOption(DataOptionKey.ENCODING, (Charset)parameters.getValue(ENCODING));
        storageConnector.setOption(DataOptionKey.FOLIATION_REPRESENTATION, (FoliationRepresentation)((Object)parameters.getValue(FOLIATION)));
        return new Store(this, storageConnector);
    }

    @Override
    protected ParameterDescriptorGroup build(ParameterBuilder parameterBuilder) {
        return parameterBuilder.createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM, ENCODING, FOLIATION});
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder();
        FOLIATION = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"foliation")).setDescription((CharSequence)Resources.formatInternational((short)38))).create(FoliationRepresentation.class, (Object)FoliationRepresentation.ASSEMBLED);
    }

    private static final class Peek
    extends FirstKeywordPeek {
        static final Peek INSTANCE = new Peek();
        private static final String KEYWORD = "@stboundedby";

        private Peek() {
            super(KEYWORD.length());
        }

        @Override
        protected int isKeywordChar(int n) {
            return n == 64 ? 1 : super.isKeywordChar(n);
        }

        @Override
        protected boolean isPostKeyword(int n) {
            return n == 44;
        }

        @Override
        protected ProbeResult forKeyword(char[] cArray, int n) {
            if (n == this.maxLength && KEYWORD.equalsIgnoreCase(new String(cArray))) {
                return ProbeResult.SUPPORTED;
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

