"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const AjaxImpl_1 = require("../../impl/AjaxImpl");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const chai_1 = require("chai");
const jsdom = require("jsdom");
const { JSDOM } = jsdom;
(0, mocha_1.describe)('adds a getClientWindowTests', function () {
    // noinspection DuplicatedCode
    beforeEach(function () {
        let waitForResult = StandardInits_1.StandardInits.tobagoFileForm();
        return waitForResult.then((close) => {
            this.xhr = sinon.useFakeXMLHttpRequest();
            this.requests = [];
            this.xhr.onCreate = (xhr) => {
                this.requests.push(xhr);
            };
            global.XMLHttpRequest = this.xhr;
            window.XMLHttpRequest = this.xhr;
            this.jsfAjaxResponse = sinon.spy(global.faces.ajax, "response");
            this.closeIt = () => {
                global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                this.jsfAjaxResponse.restore();
                AjaxImpl_1.Implementation.reset();
                close();
            };
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    it("must handle a node based client window call", function (done) {
        let ret = faces.getClientWindow(document.getElementById("page::form"));
        (0, chai_1.expect)(ret).to.eq("clientWindowValue");
        done();
    });
    it("must handle a url based client id as well", function (done) {
        let waitForResult = StandardInits_1.StandardInits.defaultMyFaces();
        let oldWindow = window;
        waitForResult.then(() => {
            global["window"] = Object.create(window);
            Object.defineProperty(window, 'location', {
                value: {
                    href: oldWindow.location.href + "?jfwid=test2"
                }
            });
            let ret = faces.getClientWindow(document.body);
            (0, chai_1.expect)(ret).to.eq("test2");
            done();
        });
    });
    it("document highest priority", function (done) {
        const oldWindow = window;
        global["window"] = Object.create(window);
        Object.defineProperty(window, 'location', {
            value: {
                href: oldWindow.location.href + "?jfwid=test2"
            }
        });
        let ret = faces.getClientWindow(document.body);
        (0, chai_1.expect)(ret).to.eq("clientWindowValue");
        done();
    });
});
//# sourceMappingURL=ClientWindow.spec.js.map