/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.css.editor.module.main;

import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.lib.TestUtil;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.parsing.spi.ParseException;

/**
 *
 * @author mfukala@netbeans.org
 */
public class ValuesAndUnitsModuleTest extends CssModuleTestBase {

    public ValuesAndUnitsModuleTest(String name) {
        super(name);
    }

    public void testFunctions() throws ParseException, BadLocationException {
        String code = "p { width: attr(length, em); }";
        CssParserResult result = TestUtil.parse(code);
        
//        TestUtil.dumpResult(result);
        assertEquals(1, result.getDiagnostics().size());
        
    }
    
}
