/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.UriResourceRef;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

public abstract class ExpandSelectHelper {
    public static boolean hasSelect(SelectOption select) {
        return select != null && select.getSelectItems() != null && !select.getSelectItems().isEmpty();
    }

    public static boolean isAll(SelectOption select) {
        if (ExpandSelectHelper.hasSelect(select)) {
            for (SelectItem item : select.getSelectItems()) {
                if (!item.isStar()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static Set<String> getSelectedPropertyNames(List<SelectItem> selectItems) {
        HashSet<String> selected = new HashSet<String>();
        for (SelectItem item : selectItems) {
            UriResource resource = (UriResource)item.getResourcePath().getUriResourceParts().get(0);
            if (resource instanceof UriResourceProperty) {
                selected.add(((UriResourceProperty)resource).getProperty().getName());
                continue;
            }
            if (resource instanceof UriResourceNavigation) {
                selected.add(((UriResourceNavigation)resource).getProperty().getName());
                continue;
            }
            if (resource instanceof UriResourceAction) {
                selected.add(((UriResourceAction)resource).getAction().getName());
                continue;
            }
            if (!(resource instanceof UriResourceFunction)) continue;
            selected.add(((UriResourceFunction)resource).getFunction().getName());
        }
        return selected;
    }

    public static Set<List<String>> getSelectedPathsWithTypeCasts(List<SelectItem> selectItems, String propertyName) {
        HashSet<List<String>> selectedPaths = new HashSet<List<String>>();
        for (SelectItem item : selectItems) {
            ArrayList<String> path;
            List parts = item.getResourcePath().getUriResourceParts();
            UriResource resource = (UriResource)parts.get(0);
            if (resource instanceof UriResourceProperty && propertyName.equals(((UriResourceProperty)resource).getProperty().getName())) {
                path = new ArrayList<String>();
                if (item.getStartTypeFilter() != null) {
                    path.add(item.getStartTypeFilter().getFullQualifiedName().getFullQualifiedNameAsString());
                }
                if (resource instanceof UriResourceComplexProperty && ((UriResourceComplexProperty)resource).getComplexTypeFilter() != null) {
                    path.add(((UriResourceComplexProperty)resource).getComplexTypeFilter().getFullQualifiedName().getFullQualifiedNameAsString());
                } else if (resource instanceof UriResourceEntitySet && ((UriResourceEntitySet)resource).getTypeFilterOnCollection() != null) {
                    path.add(((UriResourceEntitySet)resource).getTypeFilterOnCollection().getFullQualifiedName().getFullQualifiedNameAsString());
                }
                ExpandSelectHelper.extractPathsFromResourceParts(selectedPaths, parts, path);
                continue;
            }
            if (!(resource instanceof UriResourceNavigation) || !propertyName.equals(((UriResourceNavigation)resource).getProperty().getName())) continue;
            path = new ArrayList();
            if (item.getStartTypeFilter() != null) {
                path.add(item.getStartTypeFilter().getFullQualifiedName().getFullQualifiedNameAsString());
            }
            ExpandSelectHelper.extractPathsFromResourceParts(selectedPaths, parts, path);
        }
        return selectedPaths.isEmpty() ? null : selectedPaths;
    }

    private static Set<List<String>> extractPathsFromResourceParts(Set<List<String>> selectedPaths, List<UriResource> parts, List<String> path) {
        if (parts.size() > 1) {
            for (UriResource part : parts.subList(1, parts.size())) {
                if (part instanceof UriResourceProperty) {
                    path.add(((UriResourceProperty)part).getProperty().getName());
                } else if (part instanceof UriResourceNavigation) {
                    path.add(((UriResourceNavigation)part).getProperty().getName());
                }
                if (!(part instanceof UriResourceComplexProperty) || ((UriResourceComplexProperty)part).getComplexTypeFilter() == null) continue;
                path.add(((UriResourceComplexProperty)part).getComplexTypeFilter().getFullQualifiedName().getFullQualifiedNameAsString());
            }
            selectedPaths.add(path);
        } else if (!path.isEmpty()) {
            selectedPaths.add(path);
        } else {
            return null;
        }
        return selectedPaths.isEmpty() ? null : selectedPaths;
    }

    public static Set<List<String>> getSelectedPaths(List<SelectItem> selectItems, String propertyName) {
        HashSet<List<String>> selectedPaths = new HashSet<List<String>>();
        for (SelectItem item : selectItems) {
            List parts = item.getResourcePath().getUriResourceParts();
            UriResource resource = (UriResource)parts.get(0);
            if (!(resource instanceof UriResourceProperty) || !propertyName.equals(((UriResourceProperty)resource).getProperty().getName())) continue;
            if (parts.size() > 1) {
                ArrayList<String> path = new ArrayList<String>();
                for (UriResource part : parts.subList(1, parts.size())) {
                    if (part instanceof UriResourceProperty) {
                        path.add(((UriResourceProperty)part).getProperty().getName());
                        continue;
                    }
                    if (!(part instanceof UriResourceNavigation)) continue;
                    path.add(((UriResourceNavigation)part).getProperty().getName());
                }
                selectedPaths.add(path);
                continue;
            }
            return null;
        }
        return selectedPaths.isEmpty() ? null : selectedPaths;
    }

    public static Set<List<String>> getSelectedPaths(List<SelectItem> selectItems) {
        HashSet<List<String>> selectedPaths = new HashSet<List<String>>();
        for (SelectItem item : selectItems) {
            List parts = item.getResourcePath().getUriResourceParts();
            UriResource resource = (UriResource)parts.get(0);
            if (!(resource instanceof UriResourceProperty)) continue;
            if (!parts.isEmpty()) {
                ArrayList<String> path = new ArrayList<String>();
                for (UriResource part : parts.subList(0, parts.size())) {
                    if (!(part instanceof UriResourceProperty)) continue;
                    path.add(((UriResourceProperty)part).getProperty().getName());
                }
                selectedPaths.add(path);
                continue;
            }
            return null;
        }
        return selectedPaths.isEmpty() ? null : selectedPaths;
    }

    public static boolean isSelected(Set<List<String>> selectedPaths, String propertyName) {
        for (List<String> path : selectedPaths) {
            if (!propertyName.equals(path.get(0))) continue;
            return true;
        }
        return false;
    }

    public static Set<List<String>> getReducedSelectedPaths(Set<List<String>> selectedPaths, String propertyName) {
        HashSet<List<String>> reducedPaths = new HashSet<List<String>>();
        for (List<String> path : selectedPaths) {
            if (!propertyName.equals(path.get(0))) continue;
            if (path.size() > 1) {
                reducedPaths.add(path.subList(1, path.size()));
                continue;
            }
            return null;
        }
        return reducedPaths.isEmpty() ? null : reducedPaths;
    }

    public static boolean hasExpand(ExpandOption expand) {
        return expand != null && expand.getExpandItems() != null && !expand.getExpandItems().isEmpty();
    }

    public static ExpandItem getExpandAll(ExpandOption expand) {
        for (ExpandItem item : expand.getExpandItems()) {
            if (!item.isStar()) continue;
            return item;
        }
        return null;
    }

    public static Set<String> getExpandedPropertyNames(List<ExpandItem> expandItems) throws SerializerException {
        HashSet<String> expanded = new HashSet<String>();
        for (ExpandItem item : expandItems) {
            List resourceParts = item.getResourcePath().getUriResourceParts();
            UriResource resource = (UriResource)resourceParts.get(0);
            if (!(resource instanceof UriResourceNavigation)) continue;
            expanded.add(((UriResourceNavigation)resource).getProperty().getName());
        }
        return expanded;
    }

    public static ExpandItem getExpandItem(List<ExpandItem> expandItems, String propertyName) {
        for (ExpandItem item : expandItems) {
            if (item.isStar()) continue;
            List resourceParts = item.getResourcePath().getUriResourceParts();
            UriResource resource = null;
            resource = resourceParts.get(resourceParts.size() - 1) instanceof UriResourceRef || resourceParts.get(resourceParts.size() - 1) instanceof UriResourceCount ? (UriResource)resourceParts.get(resourceParts.size() - 2) : (UriResource)resourceParts.get(resourceParts.size() - 1);
            if ((!(resource instanceof UriResourceNavigation) || !propertyName.equals(((UriResourceNavigation)resource).getProperty().getName())) && (!(resource instanceof UriResourceProperty) || !propertyName.equals(((UriResourceProperty)resource).getProperty().getName()))) continue;
            return item;
        }
        return null;
    }

    public static Set<List<String>> getExpandedItemsPath(ExpandOption expand) {
        HashSet<List<String>> expandPaths = new HashSet<List<String>>();
        if (expand != null) {
            List expandItems = expand.getExpandItems();
            for (ExpandItem item : expandItems) {
                List resourceParts;
                if (item.isStar() || !((resourceParts = item.getResourcePath().getUriResourceParts()).get(0) instanceof UriResourceComplexProperty)) continue;
                ArrayList<String> path = new ArrayList<String>();
                for (UriResource resource : resourceParts) {
                    if (resource instanceof UriResourceNavigation) {
                        path.add(((UriResourceNavigation)resource).getProperty().getName());
                        continue;
                    }
                    if (!(resource instanceof UriResourceProperty)) continue;
                    path.add(((UriResourceProperty)resource).getProperty().getName());
                }
                expandPaths.add(path);
            }
        }
        return expandPaths;
    }

    public static Set<List<String>> getReducedExpandItemsPaths(Set<List<String>> expandItemsPaths, String propertyName) {
        HashSet<List<String>> reducedPaths = new HashSet<List<String>>();
        for (List<String> path : expandItemsPaths) {
            if (propertyName.equals(path.get(0))) {
                if (path.size() <= 1) continue;
                reducedPaths.add(path.subList(1, path.size()));
                continue;
            }
            reducedPaths.add(path);
        }
        return reducedPaths.isEmpty() ? null : reducedPaths;
    }

    public static ExpandItem getExpandItemBasedOnType(List<ExpandItem> expandItems, String propertyName, EdmStructuredType type, String resourceName) {
        ExpandItem expandItem = null;
        for (ExpandItem item : expandItems) {
            boolean matched = false;
            if (item.isStar()) continue;
            List resourceParts = item.getResourcePath().getUriResourceParts();
            UriResource resource = null;
            if (resourceParts.size() == 1) {
                resource = (UriResource)resourceParts.get(0);
                matched = true;
                expandItem = ExpandSelectHelper.getMatchedExpandItem(propertyName, item, matched, resource);
            } else if (resourceParts.get(resourceParts.size() - 1) instanceof UriResourceRef || resourceParts.get(resourceParts.size() - 1) instanceof UriResourceCount) {
                if (resourceParts.size() == 2) {
                    resource = (UriResource)resourceParts.get(0);
                    matched = true;
                    expandItem = ExpandSelectHelper.getMatchedExpandItem(propertyName, item, matched, resource);
                } else {
                    resource = (UriResource)resourceParts.get(resourceParts.size() - 3);
                    matched = resource.getSegmentValue().equalsIgnoreCase(resourceName) ? ExpandSelectHelper.isFoundExpandItem(type, matched, resource) : false;
                    expandItem = ExpandSelectHelper.getMatchedExpandItem(propertyName, item, matched, (UriResource)resourceParts.get(resourceParts.size() - 2));
                }
            } else {
                resource = (UriResource)resourceParts.get(resourceParts.size() - 2);
                matched = resource.getSegmentValue().equalsIgnoreCase(resourceName) ? ExpandSelectHelper.isFoundExpandItem(type, matched, resource) : false;
                expandItem = ExpandSelectHelper.getMatchedExpandItem(propertyName, item, matched, (UriResource)resourceParts.get(resourceParts.size() - 1));
            }
            if (expandItem == null) continue;
            return expandItem;
        }
        return expandItem;
    }

    private static ExpandItem getMatchedExpandItem(String propertyName, ExpandItem item, boolean matched, UriResource resource) {
        if (matched && (resource instanceof UriResourceNavigation && propertyName.equals(((UriResourceNavigation)resource).getProperty().getName()) || resource instanceof UriResourceProperty && propertyName.equals(((UriResourceProperty)resource).getProperty().getName()))) {
            return item;
        }
        return null;
    }

    private static boolean isFoundExpandItem(EdmStructuredType type, boolean matched, UriResource resource) {
        if (!matched && (resource instanceof UriResourceProperty && type.compatibleTo(((UriResourceProperty)resource).getType()) || resource instanceof UriResourceNavigation && type.compatibleTo(((UriResourceNavigation)resource).getType()))) {
            matched = true;
        }
        return matched;
    }
}

