/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import org.apache.bval.DynamicMetaBean;
import org.apache.bval.MetaBeanBuilder;
import org.apache.bval.MetaBeanCache;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBeanManager
implements MetaBeanFinder {
    protected final MetaBeanCache cache = new MetaBeanCache();
    protected final MetaBeanBuilder builder;
    protected boolean complete = false;

    public MetaBeanManager() {
        this.builder = new MetaBeanBuilder();
    }

    public MetaBeanManager(MetaBeanBuilder builder) {
        this.builder = builder;
    }

    public MetaBeanBuilder getBuilder() {
        return this.builder;
    }

    public MetaBeanCache getCache() {
        return this.cache;
    }

    @Override
    public MetaBean findForId(String beanInfoId) {
        MetaBean beanInfo = this.cache.findForId(beanInfoId);
        if (beanInfo != null) {
            return beanInfo;
        }
        try {
            beanInfo = this.builder.buildForId(beanInfoId);
            this.cache.cache(beanInfo);
            this.computeRelationships(beanInfo);
            return beanInfo;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating beanInfo with id: " + beanInfoId, e);
        }
    }

    @Override
    public MetaBean findForClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        MetaBean beanInfo = this.cache.findForClass(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        try {
            beanInfo = this.builder.buildForClass(clazz);
            this.cache.cache(beanInfo);
            this.computeRelationships(beanInfo);
            return beanInfo;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating beanInfo for " + clazz, e);
        }
    }

    protected void computeRelationships(MetaBean beanInfo) {
        for (MetaProperty prop : beanInfo.getProperties()) {
            String beanRef = (String)prop.getFeature("refBeanId");
            this.computeRelatedMetaBean(prop, beanRef);
        }
    }

    protected void computeRelatedMetaBean(MetaProperty prop, String beanRef) {
        Class beanType = (Class)prop.getFeature("refBeanType");
        if (beanType != null) {
            prop.setMetaBean(this.findForClass(beanType));
        } else if (prop.getFeature("refCascade") != null) {
            prop.setMetaBean(new DynamicMetaBean(this));
        }
    }
}

