/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Constraint;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import org.apache.bval.jsr.AnnotationConstraintBuilder$buildFromAnnotation_ACTION;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.ConstraintValidation;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.xml.AnnotationProxyBuilder;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.reflection.TypeUtils;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;

@Privilized(value="DYNAMIC")
final class AnnotationConstraintBuilder<A extends Annotation> {
    private static final Logger log;
    private final ConstraintValidation<?> constraintValidation;
    private List<ConstraintOverrides> overrides;

    public AnnotationConstraintBuilder(Class<? extends ConstraintValidator<A, ?>>[] validatorClasses, A annotation, Class<?> owner, AccessStrategy access, ConstraintTarget target) {
        boolean reportFromComposite = annotation != null && annotation.annotationType().isAnnotationPresent(ReportAsSingleViolation.class);
        this.constraintValidation = new ConstraintValidation<A>(validatorClasses, annotation, owner, access, reportFromComposite, target);
        this.buildFromAnnotation();
    }

    @Privileged
    private void buildFromAnnotation() {
        if (!(System.getSecurityManager() != null)) {
            this.__privileged_buildFromAnnotation();
            return;
        }
        Object t = AccessController.doPrivileged(new AnnotationConstraintBuilder$buildFromAnnotation_ACTION(this));
    }

    static /* synthetic */ void __privileged_access$0(AnnotationConstraintBuilder annotationConstraintBuilder) {
        annotationConstraintBuilder.__privileged_buildFromAnnotation();
    }

    private void __privileged_buildFromAnnotation() {
        if (this.constraintValidation.getAnnotation() == null) {
            return;
        }
        Class<? extends Annotation> annotationType = this.constraintValidation.getAnnotation().annotationType();
        boolean foundPayload = false;
        boolean foundGroups = false;
        Method validationAppliesTo = null;
        boolean foundMessage = false;
        for (Method method : AnnotationProxyBuilder.findMethods(annotationType)) {
            if (method.getParameterTypes().length != 0) continue;
            try {
                String name = method.getName();
                if (ConstraintAnnotationAttributes.PAYLOAD.getAttributeName().equals(name)) {
                    this.buildPayload(method);
                    foundPayload = true;
                    continue;
                }
                if (ConstraintAnnotationAttributes.GROUPS.getAttributeName().equals(name)) {
                    this.buildGroups(method);
                    foundGroups = true;
                    continue;
                }
                if (ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.getAttributeName().equals(name)) {
                    this.buildValidationAppliesTo(method);
                    validationAppliesTo = method;
                    continue;
                }
                if (name.startsWith("valid")) {
                    throw new ConstraintDefinitionException("constraints parameters can't start with valid: " + name);
                }
                if (ConstraintAnnotationAttributes.MESSAGE.getAttributeName().equals(name)) {
                    foundMessage = true;
                    if (!TypeUtils.isAssignable(method.getReturnType(), ConstraintAnnotationAttributes.MESSAGE.getType())) {
                        throw new ConstraintDefinitionException("Return type for message() must be of type " + ConstraintAnnotationAttributes.MESSAGE.getType());
                    }
                }
                this.constraintValidation.getAttributes().put(name, method.invoke(this.constraintValidation.getAnnotation(), new Object[0]));
            }
            catch (ConstraintDefinitionException cde) {
                throw cde;
            }
            catch (Exception e) {
                log.log(Level.WARNING, String.format("Error processing annotation: %s ", this.constraintValidation.getAnnotation()), e);
            }
        }
        if (!foundMessage) {
            throw new ConstraintDefinitionException("Annotation " + annotationType.getName() + " has no message method");
        }
        if (!foundPayload) {
            throw new ConstraintDefinitionException("Annotation " + annotationType.getName() + " has no payload method");
        }
        if (!foundGroups) {
            throw new ConstraintDefinitionException("Annotation " + annotationType.getName() + " has no groups method");
        }
        if (validationAppliesTo != null && !ConstraintTarget.IMPLICIT.equals(validationAppliesTo.getDefaultValue())) {
            throw new ConstraintDefinitionException("validationAppliesTo default value should be IMPLICIT");
        }
        Constraint annotation = annotationType.getAnnotation(Constraint.class);
        if (annotation == null) {
            return;
        }
        Pair validationTarget = this.computeValidationTarget(annotation.validatedBy());
        for (Annotation a : annotationType.getAnnotations()) {
            Constraint inheritedConstraint;
            Class<? extends Annotation> aClass = a.annotationType();
            if (aClass.getName().startsWith("java.lang.annotation.") || (inheritedConstraint = aClass.getAnnotation(Constraint.class)) == null || aClass.getName().startsWith("javax.validation.constraints.")) continue;
            Pair validationTargetInherited = this.computeValidationTarget(inheritedConstraint.validatedBy());
            if ((validationTarget.a <= 0 || validationTargetInherited.b <= 0 || validationTarget.b != 0) && (validationTarget.b <= 0 || validationTargetInherited.a <= 0 || validationTarget.a != 0)) continue;
            throw new ConstraintDefinitionException("Parent and child constraint have different targets");
        }
    }

    private Pair computeValidationTarget(Class<?>[] validators) {
        int param = 0;
        int annotatedElt = 0;
        for (Class<?> validator : validators) {
            SupportedValidationTarget supportedAnnotationTypes = validator.getAnnotation(SupportedValidationTarget.class);
            if (supportedAnnotationTypes != null) {
                List<ValidationTarget> values = Arrays.asList(supportedAnnotationTypes.value());
                if (values.contains((Object)ValidationTarget.PARAMETERS)) {
                    ++param;
                }
                if (!values.contains((Object)ValidationTarget.ANNOTATED_ELEMENT)) continue;
                ++annotatedElt;
                continue;
            }
            ++annotatedElt;
        }
        if (annotatedElt == 0 && param >= 1 && this.constraintValidation.getValidationAppliesTo() != null) {
            throw new ConstraintDefinitionException("pure cross parameter constraints shouldn't get validationAppliesTo attribute");
        }
        if (param >= 1 && annotatedElt >= 1 && this.constraintValidation.getValidationAppliesTo() == null) {
            throw new ConstraintDefinitionException("cross parameter AND generic constraints should get validationAppliesTo attribute");
        }
        if (param == 0 && this.constraintValidation.getValidationAppliesTo() != null) {
            throw new ConstraintDefinitionException("pure generic constraints shouldn't get validationAppliesTo attribute");
        }
        return new Pair(annotatedElt, param);
    }

    private void buildValidationAppliesTo(Method method) throws InvocationTargetException, IllegalAccessException {
        if (!TypeUtils.isAssignable(method.getReturnType(), ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.getType())) {
            throw new ConstraintDefinitionException("Return type for validationAppliesTo() must be of type " + ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.getType());
        }
        Object validationAppliesTo = method.invoke(this.constraintValidation.getAnnotation(), new Object[0]);
        if (!ConstraintTarget.class.isInstance(validationAppliesTo)) {
            throw new ConstraintDefinitionException("validationAppliesTo type is " + ConstraintTarget.class.getName());
        }
        this.constraintValidation.setValidationAppliesTo((ConstraintTarget)((Object)ConstraintTarget.class.cast(validationAppliesTo)));
    }

    private void buildGroups(Method method) throws IllegalAccessException, InvocationTargetException {
        Class[] garr;
        if (!TypeUtils.isAssignable(method.getReturnType(), ConstraintAnnotationAttributes.GROUPS.getType())) {
            throw new ConstraintDefinitionException("Return type for groups() must be of type " + ConstraintAnnotationAttributes.GROUPS.getType());
        }
        Object raw = method.invoke(this.constraintValidation.getAnnotation(), new Object[0]);
        if (raw instanceof Class) {
            garr = new Class[]{(Class)raw};
        } else if (raw instanceof Class[]) {
            garr = (Class[])raw;
            if (((Object[])Object[].class.cast(method.getDefaultValue())).length > 0) {
                throw new ConstraintDefinitionException("Default value for groups() must be an empty array");
            }
        } else {
            garr = null;
        }
        if (garr == null || garr.length == 0) {
            garr = GroupsComputer.DEFAULT_GROUP;
        }
        this.constraintValidation.setGroups(garr);
    }

    private void buildPayload(Method method) throws IllegalAccessException, InvocationTargetException {
        Set<Class<? extends Payload>> payloadSet;
        if (!TypeUtils.isAssignable(method.getReturnType(), ConstraintAnnotationAttributes.PAYLOAD.getType())) {
            throw new ConstraintDefinitionException("Return type for payload() must be of type " + ConstraintAnnotationAttributes.PAYLOAD.getType());
        }
        if (((Object[])Object[].class.cast(method.getDefaultValue())).length > 0) {
            throw new ConstraintDefinitionException("Default value for payload() must be an empty array");
        }
        Class[] payload_raw = (Class[])method.invoke(this.constraintValidation.getAnnotation(), new Object[0]);
        if (payload_raw == null) {
            payloadSet = Collections.emptySet();
        } else {
            payloadSet = new HashSet(payload_raw.length);
            Collections.addAll(payloadSet, payload_raw);
        }
        this.constraintValidation.setPayload(payloadSet);
    }

    public ConstraintValidation<?> getConstraintValidation() {
        return this.constraintValidation;
    }

    public void addComposed(ConstraintValidation<?> composite) {
        this.applyOverridesAttributes(composite);
        if (this.constraintValidation.getValidationAppliesTo() != null) {
            composite.setValidationAppliesTo(this.constraintValidation.getValidationAppliesTo());
        }
        this.constraintValidation.addComposed(composite);
    }

    private void applyOverridesAttributes(ConstraintValidation<?> composite) {
        if (null == this.overrides) {
            this.buildOverridesAttributes();
        }
        if (!this.overrides.isEmpty()) {
            ConstraintOverrides override;
            int index = this.computeIndex(composite);
            ConstraintOverrides generalOverride = this.findOverride(composite.getAnnotation().annotationType(), -1);
            if (generalOverride != null) {
                if (index > 0) {
                    throw new ConstraintDeclarationException("Wrong OverridesAttribute declaration for " + generalOverride.constraintType + ", it needs a defined index when there is a list of constraints");
                }
                generalOverride.applyOn(composite);
            }
            if ((override = this.findOverride(composite.getAnnotation().annotationType(), index)) != null) {
                override.applyOn(composite);
            }
        }
    }

    private int computeIndex(ConstraintValidation<?> composite) {
        int idx = 0;
        for (ConstraintValidation<?> each : this.constraintValidation.getComposingValidations()) {
            if (each.getAnnotation().annotationType() != composite.getAnnotation().annotationType()) continue;
            ++idx;
        }
        return idx;
    }

    private void buildOverridesAttributes() {
        this.overrides = new LinkedList<ConstraintOverrides>();
        for (Method method : this.constraintValidation.getAnnotation().annotationType().getDeclaredMethods()) {
            OverridesAttribute overridesAttribute;
            OverridesAttribute.List overridesAttributeList = method.getAnnotation(OverridesAttribute.List.class);
            if (overridesAttributeList != null) {
                for (OverridesAttribute overridesAttribute2 : overridesAttributeList.value()) {
                    this.parseConstraintOverride(method.getName(), overridesAttribute2);
                }
            }
            if ((overridesAttribute = method.getAnnotation(OverridesAttribute.class)) == null) continue;
            this.parseConstraintOverride(method.getName(), overridesAttribute);
        }
    }

    private void parseConstraintOverride(String methodName, OverridesAttribute oa) {
        ConstraintOverrides target = this.findOverride(oa.constraint(), oa.constraintIndex());
        if (target == null) {
            target = new ConstraintOverrides(oa.constraint(), oa.constraintIndex());
            this.overrides.add(target);
        }
        target.values.put(oa.name(), this.constraintValidation.getAttributes().get(methodName));
    }

    private ConstraintOverrides findOverride(Class<? extends Annotation> constraint, int constraintIndex) {
        for (ConstraintOverrides each : this.overrides) {
            if (each.constraintType != constraint || each.constraintIndex != constraintIndex) continue;
            return each;
        }
        return null;
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(AnnotationConstraintBuilder.class.getName());
    }

    static {
        AnnotationConstraintBuilder.__privileged_clinit0();
    }

    private static class Pair {
        private int a;
        private int b;

        private Pair(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    private static final class ConstraintOverrides {
        final Class<? extends Annotation> constraintType;
        final int constraintIndex;
        final Map<String, Object> values;

        private ConstraintOverrides(Class<? extends Annotation> constraintType, int constraintIndex) {
            this.constraintType = constraintType;
            this.constraintIndex = constraintIndex;
            this.values = new HashMap<String, Object>();
        }

        private void applyOn(ConstraintValidation<?> composite) {
            composite.getAttributes().putAll(this.values);
            Object originalAnnot = composite.getAnnotation();
            AnnotationProxyBuilder apb = new AnnotationProxyBuilder(originalAnnot);
            for (String key : this.values.keySet()) {
                apb.putValue(key, this.values.get(key));
            }
            Object newAnnot = apb.createAnnotation();
            composite.setAnnotation(newAnnot);
        }
    }
}

