/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.BitSet;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.kernel.AbstractPCData;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCDataImpl;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;

public class DataCachePCDataImpl
extends PCDataImpl
implements DataCachePCData {
    private static final long serialVersionUID = 1L;
    private final long _exp;

    public DataCachePCDataImpl(Object oid, ClassMetaData meta) {
        this(oid, meta, "default");
    }

    public DataCachePCDataImpl(Object oid, ClassMetaData meta, String name) {
        super(oid, meta, name);
        int timeout = meta.getDataCacheTimeout();
        this._exp = timeout > 0 ? System.currentTimeMillis() + (long)timeout : -1L;
    }

    @Override
    public boolean isTimedOut() {
        return this._exp != -1L && this._exp < System.currentTimeMillis();
    }

    @Override
    public long getTimeOut() {
        return this._exp;
    }

    @Override
    public synchronized Object getData(int index) {
        return super.getData(index);
    }

    @Override
    public synchronized void setData(int index, Object val) {
        super.setData(index, val);
    }

    @Override
    public synchronized void clearData(int index) {
        super.clearData(index);
    }

    @Override
    public synchronized Object getImplData() {
        return super.getImplData();
    }

    @Override
    public synchronized void setImplData(Object val) {
        super.setImplData(val);
    }

    @Override
    public synchronized Object getImplData(int index) {
        return super.getImplData(index);
    }

    @Override
    public synchronized void setImplData(int index, Object val) {
        super.setImplData(index, val);
    }

    @Override
    public synchronized Object getIntermediate(int index) {
        return super.getIntermediate(index);
    }

    @Override
    public synchronized void setIntermediate(int index, Object val) {
        super.setIntermediate(index, val);
    }

    @Override
    public synchronized boolean isLoaded(int index) {
        return super.isLoaded(index);
    }

    @Override
    public synchronized void setLoaded(int index, boolean loaded) {
        super.setLoaded(index, loaded);
    }

    @Override
    public synchronized Object getVersion() {
        return super.getVersion();
    }

    @Override
    public synchronized void setVersion(Object version) {
        super.setVersion(version);
    }

    @Override
    public synchronized void store(OpenJPAStateManager sm) {
        super.store(sm);
    }

    @Override
    public synchronized void store(OpenJPAStateManager sm, BitSet fields) {
        super.store(sm, fields);
    }

    @Override
    protected void storeField(OpenJPAStateManager sm, FieldMetaData fmd) {
        if (fmd.getManagement() != 3) {
            return;
        }
        int index = fmd.getIndex();
        if (fmd.getOrders().length > 0) {
            if (sm.getPCState() == PCState.PNEW) {
                return;
            }
            if (sm.getPCState() == PCState.PDIRTY) {
                this.clearData(index);
                return;
            }
        }
        super.storeField(sm, fmd);
        if (sm.getPCState() == PCState.PDIRTY && fmd.isUsedInOrderBy()) {
            this.clearInverseRelationCache(sm, fmd);
        }
    }

    protected void clearInverseRelationCache(OpenJPAStateManager sm, FieldMetaData fmd) {
        DataCache cache = sm.getMetaData().getDataCache();
        if (cache == null) {
            return;
        }
        ClassMetaData cmd = sm.getMetaData();
        FieldMetaData[] fields = cmd.getFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldMetaData[] inverses = fields[i].getInverseMetaDatas();
            if (inverses.length == 0) continue;
            for (FieldMetaData inverse : inverses) {
                Object oid;
                DataCachePCData data;
                if (inverse.getOrderDeclaration().indexOf(fmd.getName()) == -1 || !((data = cache.get(oid = sm.getContext().getObjectId(sm.fetch(i)))) instanceof DataCachePCDataImpl)) continue;
                ((DataCachePCDataImpl)data).clearData(inverse.getIndex());
            }
        }
    }

    @Override
    protected Object toData(FieldMetaData fmd, Object val, StoreContext ctx) {
        if (fmd.isLRS() || fmd.isStream()) {
            return NULL;
        }
        return super.toData(fmd, val, ctx);
    }

    @Override
    protected Object toNestedData(ValueMetaData vmd, Object val, StoreContext ctx) {
        if (val == null) {
            return null;
        }
        switch (vmd.getDeclaredTypeCode()) {
            case 11: 
            case 12: 
            case 13: {
                return NULL;
            }
        }
        return super.toNestedData(vmd, val, ctx);
    }

    @Override
    public AbstractPCData newEmbeddedPCData(OpenJPAStateManager sm) {
        return new DataCachePCDataImpl(sm.getId(), sm.getMetaData(), this.getCache());
    }
}

