/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.debugger.ui.XrefEntry;
import org.apache.pdfbox.pdmodel.PDDocument;

public class XrefEntries {
    public static final String PATH = "CRT";
    private final List<Map.Entry<COSObjectKey, Long>> entries;
    private final COSDocument document;

    public XrefEntries(PDDocument document) {
        Map<COSObjectKey, Long> xrefTable = document.getDocument().getXrefTable();
        this.entries = xrefTable.entrySet().stream().sorted(Comparator.comparingLong(e -> ((COSObjectKey)e.getKey()).getNumber())).collect(Collectors.toList());
        this.document = document.getDocument();
    }

    public int getXrefEntryCount() {
        return this.entries.size();
    }

    public XrefEntry getXrefEntry(int index) {
        Map.Entry<COSObjectKey, Long> entry = this.entries.get(index);
        COSObject objectFromPool = this.document.getObjectFromPool(entry.getKey());
        return new XrefEntry(index, entry.getKey(), entry.getValue(), objectFromPool);
    }

    public int indexOf(XrefEntry xrefEntry) {
        COSObjectKey key = xrefEntry.getKey();
        Map.Entry entry = this.entries.stream().filter(e -> key.equals(e.getKey())).findFirst().orElse(null);
        return entry != null ? this.entries.indexOf(entry) : 0;
    }

    public String toString() {
        return PATH;
    }
}

