/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAPDUSegmentTimeout is the corresponding interface of BACnetConstructedDataAPDUSegmentTimeout
type BACnetConstructedDataAPDUSegmentTimeout interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetApduSegmentTimeout returns ApduSegmentTimeout (property field)
	GetApduSegmentTimeout() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataAPDUSegmentTimeout is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAPDUSegmentTimeout()
	// CreateBuilder creates a BACnetConstructedDataAPDUSegmentTimeoutBuilder
	CreateBACnetConstructedDataAPDUSegmentTimeoutBuilder() BACnetConstructedDataAPDUSegmentTimeoutBuilder
}

// _BACnetConstructedDataAPDUSegmentTimeout is the data-structure of this message
type _BACnetConstructedDataAPDUSegmentTimeout struct {
	BACnetConstructedDataContract
	ApduSegmentTimeout BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataAPDUSegmentTimeout = (*_BACnetConstructedDataAPDUSegmentTimeout)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAPDUSegmentTimeout)(nil)

// NewBACnetConstructedDataAPDUSegmentTimeout factory function for _BACnetConstructedDataAPDUSegmentTimeout
func NewBACnetConstructedDataAPDUSegmentTimeout(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, apduSegmentTimeout BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAPDUSegmentTimeout {
	if apduSegmentTimeout == nil {
		panic("apduSegmentTimeout of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataAPDUSegmentTimeout must not be nil")
	}
	_result := &_BACnetConstructedDataAPDUSegmentTimeout{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ApduSegmentTimeout:            apduSegmentTimeout,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAPDUSegmentTimeoutBuilder is a builder for BACnetConstructedDataAPDUSegmentTimeout
type BACnetConstructedDataAPDUSegmentTimeoutBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(apduSegmentTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUSegmentTimeoutBuilder
	// WithApduSegmentTimeout adds ApduSegmentTimeout (property field)
	WithApduSegmentTimeout(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUSegmentTimeoutBuilder
	// WithApduSegmentTimeoutBuilder adds ApduSegmentTimeout (property field) which is build by the builder
	WithApduSegmentTimeoutBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAPDUSegmentTimeoutBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAPDUSegmentTimeout or returns an error if something is wrong
	Build() (BACnetConstructedDataAPDUSegmentTimeout, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAPDUSegmentTimeout
}

// NewBACnetConstructedDataAPDUSegmentTimeoutBuilder() creates a BACnetConstructedDataAPDUSegmentTimeoutBuilder
func NewBACnetConstructedDataAPDUSegmentTimeoutBuilder() BACnetConstructedDataAPDUSegmentTimeoutBuilder {
	return &_BACnetConstructedDataAPDUSegmentTimeoutBuilder{_BACnetConstructedDataAPDUSegmentTimeout: new(_BACnetConstructedDataAPDUSegmentTimeout)}
}

type _BACnetConstructedDataAPDUSegmentTimeoutBuilder struct {
	*_BACnetConstructedDataAPDUSegmentTimeout

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAPDUSegmentTimeoutBuilder) = (*_BACnetConstructedDataAPDUSegmentTimeoutBuilder)(nil)

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAPDUSegmentTimeout
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) WithMandatoryFields(apduSegmentTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUSegmentTimeoutBuilder {
	return b.WithApduSegmentTimeout(apduSegmentTimeout)
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) WithApduSegmentTimeout(apduSegmentTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAPDUSegmentTimeoutBuilder {
	b.ApduSegmentTimeout = apduSegmentTimeout
	return b
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) WithApduSegmentTimeoutBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAPDUSegmentTimeoutBuilder {
	builder := builderSupplier(b.ApduSegmentTimeout.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.ApduSegmentTimeout, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) Build() (BACnetConstructedDataAPDUSegmentTimeout, error) {
	if b.ApduSegmentTimeout == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'apduSegmentTimeout' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAPDUSegmentTimeout.deepCopy(), nil
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) MustBuild() BACnetConstructedDataAPDUSegmentTimeout {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAPDUSegmentTimeoutBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAPDUSegmentTimeoutBuilder().(*_BACnetConstructedDataAPDUSegmentTimeoutBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAPDUSegmentTimeoutBuilder creates a BACnetConstructedDataAPDUSegmentTimeoutBuilder
func (b *_BACnetConstructedDataAPDUSegmentTimeout) CreateBACnetConstructedDataAPDUSegmentTimeoutBuilder() BACnetConstructedDataAPDUSegmentTimeoutBuilder {
	if b == nil {
		return NewBACnetConstructedDataAPDUSegmentTimeoutBuilder()
	}
	return &_BACnetConstructedDataAPDUSegmentTimeoutBuilder{_BACnetConstructedDataAPDUSegmentTimeout: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetApduSegmentTimeout() BACnetApplicationTagUnsignedInteger {
	return m.ApduSegmentTimeout
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetApduSegmentTimeout())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAPDUSegmentTimeout(structType any) BACnetConstructedDataAPDUSegmentTimeout {
	if casted, ok := structType.(BACnetConstructedDataAPDUSegmentTimeout); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAPDUSegmentTimeout); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetTypeName() string {
	return "BACnetConstructedDataAPDUSegmentTimeout"
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (apduSegmentTimeout)
	lengthInBits += m.ApduSegmentTimeout.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAPDUSegmentTimeout BACnetConstructedDataAPDUSegmentTimeout, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAPDUSegmentTimeout"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAPDUSegmentTimeout")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	apduSegmentTimeout, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "apduSegmentTimeout", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'apduSegmentTimeout' field"))
	}
	m.ApduSegmentTimeout = apduSegmentTimeout

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), apduSegmentTimeout)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAPDUSegmentTimeout"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAPDUSegmentTimeout")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAPDUSegmentTimeout"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAPDUSegmentTimeout")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "apduSegmentTimeout", m.GetApduSegmentTimeout(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'apduSegmentTimeout' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAPDUSegmentTimeout"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAPDUSegmentTimeout")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) IsBACnetConstructedDataAPDUSegmentTimeout() {}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) deepCopy() *_BACnetConstructedDataAPDUSegmentTimeout {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAPDUSegmentTimeoutCopy := &_BACnetConstructedDataAPDUSegmentTimeout{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.ApduSegmentTimeout),
	}
	_BACnetConstructedDataAPDUSegmentTimeoutCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAPDUSegmentTimeoutCopy
}

func (m *_BACnetConstructedDataAPDUSegmentTimeout) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
